/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.logging.Logger;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationLiteralTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.provider.AnalyzeJavaFilesRuleProvider;
import org.jboss.windup.rules.apps.javaee.model.JaxRSWebServiceModel;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverJaxRsAnnotationsRuleProvider
extends AbstractRuleProvider {
    private static Logger LOG = Logging.get(DiscoverJaxRsAnnotationsRuleProvider.class);
    private static final String JAXRS_ANNOTATIONS = "jaxrsAnnotations";

    public DiscoverJaxRsAnnotationsRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverJaxRsAnnotationsRuleProvider.class).setPhase(InitialAnalysisPhase.class).addExecuteAfter(AnalyzeJavaFilesRuleProvider.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        String ruleIDPrefix = ((Object)((Object)this)).getClass().getSimpleName();
        return ConfigurationBuilder.begin().addRule().when((Condition)JavaClass.references((String)"javax.ws.rs.Path").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION}).as(JAXRS_ANNOTATIONS)).perform((Operation)Iteration.over((String)JAXRS_ANNOTATIONS).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                DiscoverJaxRsAnnotationsRuleProvider.this.extractMetadata(event, payload);
            }
        }).endIteration()).withId(ruleIDPrefix + "_JAXRSAnnotationRule");
    }

    private String getAnnotationLiteralValue(JavaAnnotationTypeReferenceModel model, String name) {
        JavaAnnotationTypeValueModel valueModel = (JavaAnnotationTypeValueModel)model.getAnnotationValues().get(name);
        if (valueModel instanceof JavaAnnotationLiteralTypeValueModel) {
            JavaAnnotationLiteralTypeValueModel literalTypeValue = (JavaAnnotationLiteralTypeValueModel)valueModel;
            return literalTypeValue.getLiteralValue();
        }
        return null;
    }

    private void extractMetadata(GraphRewrite event, JavaTypeReferenceModel typeReference) {
        ((SourceFileModel)typeReference.getFile()).setGenerateSourceReport(true);
        JavaAnnotationTypeReferenceModel jaxRSAnnotationTypeReference = (JavaAnnotationTypeReferenceModel)typeReference;
        String pathName = this.getAnnotationLiteralValue(jaxRSAnnotationTypeReference, "value");
        GraphService jaxRSService = new GraphService(event.getGraphContext(), JaxRSWebServiceModel.class);
        JaxRSWebServiceModel jaxWebService = (JaxRSWebServiceModel)jaxRSService.create();
        jaxWebService.setPath(pathName);
        JavaClassModel jcm = this.getJavaClass(typeReference);
        if (jcm != null) {
            jaxWebService.setImplementationClass(jcm);
        }
    }

    private JavaClassModel getJavaClass(JavaTypeReferenceModel javaTypeReference) {
        JavaClassModel result = null;
        FileModel originalFile = javaTypeReference.getFile();
        if (originalFile instanceof JavaSourceFileModel) {
            JavaSourceFileModel javaSource = (JavaSourceFileModel)originalFile;
            for (JavaClassModel javaClassModel : javaSource.getJavaClasses()) {
                if (javaClassModel.isPublic() == null || !javaClassModel.isPublic().booleanValue()) continue;
                result = javaClassModel;
                break;
            }
            if (result == null) {
                result = (JavaClassModel)javaSource.getJavaClasses().iterator().next();
            }
        } else if (originalFile instanceof JavaClassFileModel) {
            result = ((JavaClassFileModel)originalFile).getJavaClass();
        } else {
            LOG.warning("Unrecognized file type with annotation found at: \"" + originalFile.getFilePath() + "\"");
        }
        return result;
    }

    public String toString() {
        return "DiscoverEJBAnnotatedClasses";
    }
}

