/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.HashMap;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.model.TechnologyTagModel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.DataSourceModel;
import org.jboss.windup.rules.apps.javaee.model.JPAConfigurationFileModel;
import org.jboss.windup.rules.apps.javaee.model.JPAEntityModel;
import org.jboss.windup.rules.apps.javaee.model.JPAPersistenceUnitModel;
import org.jboss.windup.rules.apps.javaee.service.DataSourceService;
import org.jboss.windup.rules.apps.javaee.service.JPAConfigurationFileService;
import org.jboss.windup.rules.apps.javaee.service.JPAEntityService;
import org.jboss.windup.rules.apps.javaee.service.JPAPersistenceUnitService;
import org.jboss.windup.rules.apps.javaee.util.HibernateDialectDataSourceTypeResolver;
import org.jboss.windup.rules.apps.xml.model.NamespaceMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.Logging;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiscoverJpaConfigurationXmlRuleProvider
extends IteratingRuleProvider<NamespaceMetaModel> {
    private static final Logger LOG = Logging.get(DiscoverJpaConfigurationXmlRuleProvider.class);
    private static final String TECH_TAG = "JPA XML";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.INFORMATIONAL;

    public DiscoverJpaConfigurationXmlRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverJpaConfigurationXmlRuleProvider.class).setPhase(InitialAnalysisPhase.class));
    }

    public String toStringPerform() {
        return "Discover JPA Persistence XML Files";
    }

    public ConditionBuilder when() {
        return Query.fromType(NamespaceMetaModel.class).withProperty("namespaceURI", (Object)"http://java.sun.com/xml/ns/persistence");
    }

    public void perform(GraphRewrite event, EvaluationContext context, NamespaceMetaModel payload) {
        for (XmlFileModel xml : payload.getXmlResources()) {
            Document doc;
            if (!StringUtils.equals((String)xml.getRootTagName(), (String)"persistence") || (doc = new XmlFileService(event.getGraphContext()).loadDocumentQuiet(context, xml)) == null) continue;
            this.extractMetadata(event.getGraphContext(), xml, doc);
        }
    }

    private void extractMetadata(GraphContext graphContext, XmlFileModel xmlFileModel, Document doc) {
        DataSourceService dataSourceService = new DataSourceService(graphContext);
        JavaClassService javaClassService = new JavaClassService(graphContext);
        JPAConfigurationFileService jpaConfigurationFileService = new JPAConfigurationFileService(graphContext);
        JPAPersistenceUnitService jpaPersistenceUnitService = new JPAPersistenceUnitService(graphContext);
        JPAEntityService jpaEntityService = new JPAEntityService(graphContext);
        TechnologyTagService technologyTagService = new TechnologyTagService(graphContext);
        TechnologyTagModel technologyTag = technologyTagService.addTagToFileModel((FileModel)xmlFileModel, TECH_TAG, TECH_TAG_LEVEL);
        String version = JOOX.$((Document)doc).attr("version");
        if (StringUtils.isNotBlank((String)version)) {
            technologyTag.setVersion(version);
        }
        JPAConfigurationFileModel jpaConfigurationModel = (JPAConfigurationFileModel)jpaConfigurationFileService.addTypeToModel((WindupVertexFrame)xmlFileModel);
        if (StringUtils.isNotBlank((String)version)) {
            jpaConfigurationModel.setSpecificationVersion(version);
        }
        for (Element element : JOOX.$((Document)doc).find("persistence-unit").get()) {
            Object clz2;
            DataSourceModel dataSource;
            Object dataSourceName;
            Object dataSourceJndiName;
            JPAPersistenceUnitModel persistenceUnitModel = (JPAPersistenceUnitModel)jpaPersistenceUnitService.create();
            String persistenceUnitName = JOOX.$((Element)element).attr("name");
            persistenceUnitModel.setName(persistenceUnitName);
            jpaConfigurationModel.addPersistenceUnit(persistenceUnitModel);
            if (JOOX.$((Element)element).find("jta-data-source").isNotEmpty()) {
                dataSourceJndiName = JOOX.$((Element)element).find("jta-data-source").text();
                dataSourceName = dataSourceJndiName;
                if (StringUtils.contains((String)dataSourceName, (String)"/")) {
                    dataSourceName = StringUtils.substringAfterLast((String)dataSourceName, (String)"/");
                }
                dataSource = dataSourceService.createUnique((String)dataSourceName, (String)dataSourceJndiName);
                persistenceUnitModel.addDataSource(dataSource);
            }
            if (JOOX.$((Element)element).find("non-jta-data-source").isNotEmpty()) {
                dataSourceJndiName = JOOX.$((Element)element).find("non-jta-data-source").text();
                dataSourceName = dataSourceJndiName;
                if (StringUtils.contains((String)dataSourceName, (String)"/")) {
                    dataSourceName = StringUtils.substringAfterLast((String)dataSourceName, (String)"/");
                }
                dataSource = dataSourceService.createUnique((String)dataSourceName, (String)dataSourceJndiName);
                persistenceUnitModel.addDataSource(dataSource);
            }
            for (Object clz2 : JOOX.$((Element)element).find("class").get()) {
                String clzName = JOOX.$((Element)clz2).text();
                JavaClassModel javaClz = javaClassService.getOrCreatePhantom(clzName);
                JPAEntityModel entityModel = (JPAEntityModel)jpaEntityService.create();
                entityModel.setJavaClass(javaClz);
            }
            HashMap<String, String> persistenceUnitProperties = new HashMap<String, String>();
            clz2 = JOOX.$((Element)element).find("property").iterator();
            while (clz2.hasNext()) {
                Element propElement = (Element)clz2.next();
                String propKey = JOOX.$((Element)propElement).attr("name");
                String propValue = JOOX.$((Element)propElement).attr("value");
                persistenceUnitProperties.put(propKey, propValue);
            }
            if (persistenceUnitProperties.containsKey("hibernate.dialect")) {
                String dialect = (String)persistenceUnitProperties.get("hibernate.dialect");
                for (DataSourceModel datasource : persistenceUnitModel.getDataSources()) {
                    datasource.setDatabaseTypeName(HibernateDialectDataSourceTypeResolver.resolveDataSourceTypeFromDialect(dialect));
                }
            }
            persistenceUnitModel.setProperties(persistenceUnitProperties);
        }
    }
}

