/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.MigrationRulesPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.RMIServiceModel;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverRmiRuleProvider
extends AbstractRuleProvider {
    private static Logger LOG = Logging.get(DiscoverRmiRuleProvider.class);
    private static final String RMI_INHERITANCE = "rmiInheritance";

    public DiscoverRmiRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverRmiRuleProvider.class).setPhase(MigrationRulesPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        String ruleIDPrefix = ((Object)((Object)this)).getClass().getSimpleName();
        return ConfigurationBuilder.begin().addRule().when((Condition)JavaClass.references((String)"java.rmi.Remote").at(new TypeReferenceLocation[]{TypeReferenceLocation.IMPORT}).as(RMI_INHERITANCE)).perform((Operation)Iteration.over((String)RMI_INHERITANCE).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                DiscoverRmiRuleProvider.this.extractMetadata(event, payload);
            }
        }).endIteration()).withId(ruleIDPrefix + "_RMIInheritanceRule");
    }

    private void extractMetadata(GraphRewrite event, JavaTypeReferenceModel typeReference) {
        JavaClassService jcs = new JavaClassService(event.getGraphContext());
        JavaClassModel jcm = this.getJavaClass(typeReference);
        if (!this.isRemote(jcm)) {
            LOG.warning("Is not remote: " + jcm.getQualifiedName());
            return;
        }
        LOG.info("Processing: " + typeReference);
        ((SourceFileModel)typeReference.getFile()).setGenerateSourceReport(true);
        GraphService rmiService = new GraphService(event.getGraphContext(), RMIServiceModel.class);
        if (jcm != null) {
            Iterator impls = jcm.getImplementedBy().iterator();
            if (impls.hasNext()) {
                RMIServiceModel rmiServiceModel = (RMIServiceModel)rmiService.create();
                rmiServiceModel.setInterface(jcm);
                LOG.info("RMI Interface: " + jcm.getQualifiedName());
                while (impls.hasNext()) {
                    JavaClassModel implModel = (JavaClassModel)impls.next();
                    LOG.info(" -- Impementations: " + implModel.getQualifiedName());
                    rmiServiceModel.setImplementationClass(implModel);
                    for (JavaSourceFileModel source : jcs.getJavaSource(implModel.getQualifiedName())) {
                        source.setGenerateSourceReport(true);
                    }
                }
            } else {
                LOG.info("No implementations for RMI Interface: " + jcm.getQualifiedName());
                RMIServiceModel rmiServiceModel = (RMIServiceModel)rmiService.create();
                rmiServiceModel.setInterface(jcm);
            }
        }
    }

    public boolean isRemote(JavaClassModel jcm) {
        LOG.info("Class: " + jcm.getQualifiedName());
        for (JavaClassModel im : jcm.getInterfaces()) {
            if (StringUtils.equals((CharSequence)"java.rmi.Remote", (CharSequence)im.getQualifiedName())) {
                return true;
            }
            LOG.info(" - Implements: " + im.getQualifiedName());
        }
        if (jcm.getExtends() != null) {
            LOG.info(" - Extends: " + jcm.getExtends().getQualifiedName());
            return StringUtils.equals((CharSequence)"java.rmi.Remote", (CharSequence)jcm.getExtends().getQualifiedName());
        }
        return false;
    }

    private JavaClassModel getJavaClass(JavaTypeReferenceModel javaTypeReference) {
        JavaClassModel result = null;
        FileModel originalFile = javaTypeReference.getFile();
        if (originalFile instanceof JavaSourceFileModel) {
            JavaSourceFileModel javaSource = (JavaSourceFileModel)originalFile;
            for (JavaClassModel javaClassModel : javaSource.getJavaClasses()) {
                if (javaClassModel.isPublic() == null || !javaClassModel.isPublic().booleanValue()) continue;
                result = javaClassModel;
                break;
            }
            if (result == null) {
                result = (JavaClassModel)javaSource.getJavaClasses().iterator().next();
            }
        } else if (originalFile instanceof JavaClassFileModel) {
            result = ((JavaClassFileModel)originalFile).getJavaClass();
        } else {
            LOG.warning("Unrecognized file type with annotation found at: \"" + originalFile.getFilePath() + "\"");
        }
        return result;
    }

    public String toString() {
        return "DiscoverEJBAnnotatedClasses";
    }
}

