/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.decompiler;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.DependencyVisitor;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.scan.ast.ignore.JavaClassIgnoreResolver;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ClassFilePreDecompilationScan
extends AbstractIterationOperation<JavaClassFileModel> {
    private static Logger LOG = Logging.get(ClassFilePreDecompilationScan.class);

    private void addClassFileMetadata(GraphRewrite event, EvaluationContext context, JavaClassFileModel javaClassFileModel) {
        try (FileInputStream fis = new FileInputStream(javaClassFileModel.getFilePath());){
            ClassParser parser = new ClassParser((InputStream)fis, javaClassFileModel.getFilePath());
            JavaClass bcelJavaClass = parser.parse();
            String packageName = bcelJavaClass.getPackageName();
            String qualifiedName = bcelJavaClass.getClassName();
            JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
            JavaClassModel javaClassModel = javaClassService.create(qualifiedName);
            int majorVersion = bcelJavaClass.getMajor();
            int minorVersion = bcelJavaClass.getMinor();
            String simpleName = qualifiedName;
            if (packageName != null && !packageName.equals("") && simpleName != null) {
                simpleName = StringUtils.substringAfterLast((String)simpleName, (String)".");
            }
            javaClassFileModel.setMajorVersion(majorVersion);
            javaClassFileModel.setMinorVersion(minorVersion);
            javaClassFileModel.setPackageName(packageName);
            javaClassModel.setSimpleName(simpleName);
            javaClassModel.setPackageName(packageName);
            javaClassModel.setQualifiedName(qualifiedName);
            javaClassModel.setClassFile(javaClassFileModel);
            javaClassModel.setPublic(bcelJavaClass.isPublic());
            javaClassModel.setInterface(bcelJavaClass.isInterface());
            String[] interfaceNames = bcelJavaClass.getInterfaceNames();
            if (interfaceNames != null) {
                for (String interfaceName : interfaceNames) {
                    JavaClassModel interfaceModel = javaClassService.getOrCreatePhantom(interfaceName);
                    javaClassService.addInterface(javaClassModel, interfaceModel);
                }
            }
            String superclassName = bcelJavaClass.getSuperclassName();
            if (!bcelJavaClass.isInterface() && !StringUtils.isBlank((String)superclassName)) {
                javaClassModel.setExtends(javaClassService.getOrCreatePhantom(superclassName));
            }
            javaClassFileModel.setJavaClass(javaClassModel);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "BCEL was unable to parse class file: " + javaClassFileModel.getFilePath() + " due to: " + e.getMessage(), e);
            ClassificationService classificationService = new ClassificationService(event.getGraphContext());
            classificationService.attachClassification(context, (FileModel)javaClassFileModel, "Unparseable Class File", "This Class file could not be parsed");
            javaClassFileModel.setSkipDecompilation(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(GraphRewrite event, EvaluationContext context, JavaClassFileModel fileModel) {
        ExecutionStatistics.get().begin("ClassFilePreDecompilationScan.perform()");
        try {
            Throwable throwable;
            InputStream is;
            block28: {
                block29: {
                    block26: {
                        block27: {
                            is = fileModel.asInputStream();
                            throwable = null;
                            this.addClassFileMetadata(event, context, fileModel);
                            WindupJavaConfigurationService configurationService = new WindupJavaConfigurationService(event.getGraphContext());
                            if (configurationService.shouldScanFile(fileModel.getFilePath())) break block26;
                            fileModel.asVertex().setProperty("skipDecompilation", (Object)true);
                            if (is == null) return;
                            if (throwable == null) break block27;
                            try {
                                is.close();
                                return;
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                                return;
                            }
                        }
                        is.close();
                        return;
                    }
                    if (!fileModel.getFileName().contains("$")) break block28;
                    if (is == null) return;
                    if (throwable == null) break block29;
                    try {
                        is.close();
                        return;
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                        return;
                    }
                }
                is.close();
                return;
            }
            try {
                DependencyVisitor dependencyVisitor = new DependencyVisitor();
                ClassReader classReader = new ClassReader(is);
                classReader.accept((ClassVisitor)dependencyVisitor, 0);
                Iterator<String> i$ = dependencyVisitor.classes.iterator();
                while (i$.hasNext()) {
                    String typeReference = i$.next();
                    if (!this.shouldIgnore(typeReference)) continue;
                    fileModel.asVertex().setProperty("skipDecompilation", (Object)true);
                }
                return;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                throw throwable3;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "ASM was unable to parse class file: " + fileModel.getFilePath() + " due to: " + e.getMessage(), e);
            ClassificationService classificationService = new ClassificationService(event.getGraphContext());
            classificationService.attachClassification(context, (FileModel)fileModel, "Unparseable Class File", "This Class file could not be parsed");
            return;
        }
        finally {
            ExecutionStatistics.get().end("ClassFilePreDecompilationScan.perform()");
        }
    }

    private boolean shouldIgnore(String typeReference) {
        typeReference = typeReference.replace('/', '.').replace('\\', '.');
        return JavaClassIgnoreResolver.singletonInstance().matches(typeReference);
    }
}

