/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.model.ApplicationReportIndexModel;
import org.jboss.windup.reporting.service.ApplicationReportIndexService;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;

public class ProjectModelSha1Archive
implements WindupFreeMarkerMethod {
    private static Logger LOG = Logging.get(ProjectModelSha1Archive.class);
    private static final String NAME = "projectModelSha1Archive";
    private ApplicationReportIndexService service;

    public void setContext(GraphRewrite event) {
        this.service = new ApplicationReportIndexService(event.getGraphContext());
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a parameter of type " + ProjectModel.class.getSimpleName() + " and returns the associated " + ApplicationReportIndexModel.class.getSimpleName() + ".";
    }

    public Object exec(List arguments) throws TemplateModelException {
        String result = null;
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (ProjectModel)");
        }
        StringModel stringModelArg = (StringModel)arguments.get(0);
        if (stringModelArg == null) {
            throw new IllegalArgumentException("FreeMarker Method projectModelSha1Archive called with null project model");
        }
        ProjectModel projectModel = (ProjectModel)stringModelArg.getWrappedObject();
        if (projectModel.getRootFileModel() instanceof IdentifiedArchiveModel) {
            result = projectModel.getRootFileModel().getSHA1Hash();
        }
        ExecutionStatistics.get().end(NAME);
        return result;
    }
}

