/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.rules;

import java.util.HashMap;
import javax.inject.Inject;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.reporting.model.AboutWindupModel;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateAboutWindupReportRuleProvider
extends AbstractRuleProvider {
    @Inject
    Addon addon;
    public static final String REPORT_NAME = "About";
    public static final String TEMPLATE_APPLICATION_REPORT = "/reports/templates/about_windup.ftl";

    public CreateAboutWindupReportRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(CreateAboutWindupReportRuleProvider.class).setPhase(ReportGenerationPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderFind applicationProjectModelsFound = Query.fromType(WindupConfigurationModel.class);
        AbstractIterationOperation<WindupConfigurationModel> addApplicationReport = new AbstractIterationOperation<WindupConfigurationModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, WindupConfigurationModel payload) {
                ProjectModel projectModel = payload.getInputPath().getProjectModel();
                if (projectModel == null) {
                    throw new WindupException("Error, no project found in: " + payload.getInputPath().getFilePath());
                }
                CreateAboutWindupReportRuleProvider.this.createApplicationReport(event.getGraphContext(), projectModel);
            }

            public String toString() {
                return "CreateAboutWindupReport";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)applicationProjectModelsFound).perform((Operation)addApplicationReport);
    }

    private ApplicationReportModel createApplicationReport(GraphContext context, ProjectModel projectModel) {
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = applicationReportService.create();
        applicationReportModel.setReportPriority(10000);
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReportModel.setReportName(REPORT_NAME);
        applicationReportModel.setReportIconClass("glyphicon glyphicon-info-sign");
        applicationReportModel.setMainApplicationReport(Boolean.valueOf(false));
        applicationReportModel.setProjectModel(projectModel);
        applicationReportModel.setTemplatePath(TEMPLATE_APPLICATION_REPORT);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        HashMap<String, AboutWindupModel> related = new HashMap<String, AboutWindupModel>();
        AboutWindupModel aboutWindupModel = (AboutWindupModel)context.getFramed().addVertex(null, AboutWindupModel.class);
        aboutWindupModel.setWindupRuntimeVersion(this.addon.getId().getVersion().toString());
        related.put("windupAbout", aboutWindupModel);
        applicationReportModel.setRelatedResource(related);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReportModel, "about_" + projectModel.getName(), "html");
        return applicationReportModel;
    }
}

