/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.ClassifyFileTypesPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.service.OrganizationService;
import org.jboss.windup.rules.apps.java.scan.operation.packagemapping.PackageNameMapping;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverOrganizationByPackageStructureProvider
extends AbstractRuleProvider {
    private static Logger LOG = Logging.get(DiscoverOrganizationByPackageStructureProvider.class);

    public DiscoverOrganizationByPackageStructureProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverOrganizationByPackageStructureProvider.class).setPhase(ClassifyFileTypesPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        final OrganizationService organizationService = new OrganizationService(context);
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(ArchiveModel.class)).perform((Operation)new AbstractIterationOperation<ArchiveModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
                LOG.info("Processing Archive: " + payload.getArchiveName());
                HashSet<String> packageSet = new HashSet<String>();
                HashSet<String> possibleOrganization = new HashSet<String>();
                File archiveFile = payload.asFile();
                try (ZipFile zipFile = new ZipFile(archiveFile);){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !StringUtils.endsWith((String)entry.getName(), (String)".class")) continue;
                        String pkg = DiscoverOrganizationByPackageStructureProvider.this.findPackage(payload, entry.getName());
                        packageSet.add(pkg);
                    }
                    for (String pkg : packageSet) {
                        String organization = DiscoverOrganizationByPackageStructureProvider.this.findOrganization(event, pkg);
                        if (organization == null) continue;
                        possibleOrganization.add(organization);
                    }
                }
                catch (IOException e) {
                    LOG.warning("Error loading archive: " + payload.getFileName());
                }
                if (possibleOrganization.size() == 0) {
                    LOG.info(" -- Archive: " + payload.getArchiveName() + " organization unknown.");
                    organizationService.attachOrganization(payload, "Unknown");
                } else if (possibleOrganization.size() > 1) {
                    LOG.warning(" -- Archive: " + payload.getArchiveName() + " has more than one organization: ");
                    for (String organization : possibleOrganization) {
                        organizationService.attachOrganization(payload, organization);
                        LOG.warning("   -- " + organization);
                    }
                } else {
                    organizationService.attachOrganization(payload, (String)possibleOrganization.iterator().next());
                    LOG.info(" -- Archive: " + payload.getFileName() + " has organization: " + (String)possibleOrganization.iterator().next());
                }
            }
        });
    }

    private String findOrganization(GraphRewrite context, String pkg) {
        return PackageNameMapping.getOrganizationForPackage(context, pkg);
    }

    private String findPackage(ArchiveModel payload, String entryName) {
        String packageName = StringUtils.removeEnd((String)entryName, (String)".class");
        packageName = StringUtils.replace((String)packageName, (String)"/", (String)".");
        packageName = StringUtils.substringBeforeLast((String)packageName, (String)".");
        if (StringUtils.endsWith((String)payload.getArchiveName(), (String)".war")) {
            packageName = StringUtils.substringAfterLast((String)packageName, (String)"WEB-INF.classes.");
        } else if (StringUtils.endsWith((String)payload.getArchiveName(), (String)".par")) {
            packageName = StringUtils.removeStart((String)packageName, (String)"classes.");
        }
        return packageName;
    }
}

