/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.oupls.sail;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.oupls.sail.FilteredIterator;
import com.tinkerpop.blueprints.oupls.sail.GraphSail;
import com.tinkerpop.blueprints.oupls.sail.IteratorCloseableIterable;
import com.tinkerpop.blueprints.oupls.sail.Matcher;
import java.util.Iterator;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class GraphBasedMatcher
extends Matcher {
    private final GraphSail.DataStore store;

    public GraphBasedMatcher(boolean s, boolean p, boolean o, boolean c, GraphSail.DataStore store) {
        super(s, p, o, c);
        this.store = store;
    }

    @Override
    public Iterable<Edge> match(Resource subject, final URI predicate, final Value object, Resource context, final boolean includeInferred) {
        String contextStr;
        String string = contextStr = null == context ? "N" : this.store.resourceToNative(context);
        if (this.s && this.o) {
            Vertex vs = this.store.findVertex((Value)subject);
            Vertex vo = this.store.findVertex(object);
            if (null == vs || null == vo) {
                return new IteratorCloseableIterable(new EmptyIterator());
            }
            return new FilteredIterator<Edge>(vs.getEdges(Direction.OUT, new String[0]), new FilteredIterator.Criterion<Edge>(){

                @Override
                public boolean fulfilledBy(Edge edge) {
                    return !(!GraphBasedMatcher.this.store.matches(edge.getVertex(Direction.IN), object) || GraphBasedMatcher.this.p && !edge.getLabel().equals(predicate.stringValue()) || GraphBasedMatcher.this.c && !edge.getProperty("c").equals(contextStr) || !includeInferred && null != edge.getProperty("inferred"));
                }
            });
        }
        if (this.s) {
            Vertex vs = this.store.findVertex((Value)subject);
            return null == vs ? new IteratorCloseableIterable(new EmptyIterator()) : new FilteredIterator<Edge>(vs.getEdges(Direction.OUT, new String[0]), new FilteredIterator.Criterion<Edge>(){

                @Override
                public boolean fulfilledBy(Edge edge) {
                    return !(GraphBasedMatcher.this.p && !edge.getLabel().equals(predicate.stringValue()) || GraphBasedMatcher.this.c && !edge.getProperty("c").equals(contextStr) || !includeInferred && null != edge.getProperty("inferred"));
                }
            });
        }
        Vertex vo = this.store.findVertex(object);
        return null == vo ? new IteratorCloseableIterable(new EmptyIterator()) : new FilteredIterator<Edge>(vo.getEdges(Direction.IN, new String[0]), new FilteredIterator.Criterion<Edge>(){

            @Override
            public boolean fulfilledBy(Edge edge) {
                return !(GraphBasedMatcher.this.p && !edge.getLabel().equals(predicate.stringValue()) || GraphBasedMatcher.this.c && !edge.getProperty("c").equals(contextStr) || !includeInferred && null != edge.getProperty("inferred"));
            }
        });
    }

    private class EmptyIterator<T>
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

