/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.MigrationRulesPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.model.AbstractJavaSourceModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.RMIServiceModel;
import org.jboss.windup.rules.apps.javaee.service.RMIServiceModelService;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverRmiRuleProvider
extends AbstractRuleProvider {
    private static Logger LOG = Logging.get(DiscoverRmiRuleProvider.class);
    private static final String RMI_INHERITANCE = "rmiInheritance";

    public DiscoverRmiRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverRmiRuleProvider.class).setPhase(MigrationRulesPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        String ruleIDPrefix = ((Object)((Object)this)).getClass().getSimpleName();
        return ConfigurationBuilder.begin().addRule().when((Condition)JavaClass.references((String)"java.rmi.Remote").at(new TypeReferenceLocation[]{TypeReferenceLocation.IMPORT}).as(RMI_INHERITANCE)).perform((Operation)Iteration.over((String)RMI_INHERITANCE).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                DiscoverRmiRuleProvider.this.extractMetadata(event, payload);
            }
        }).endIteration()).withId(ruleIDPrefix + "_RMIInheritanceRule");
    }

    private void extractMetadata(GraphRewrite event, JavaTypeReferenceModel typeReference) {
        JavaClassModel javaClassModel = this.getJavaClass(typeReference);
        if (!this.isRemoteInterface(javaClassModel)) {
            LOG.warning("Is not remote: " + javaClassModel.getQualifiedName());
            return;
        }
        LOG.info("Processing: " + typeReference);
        typeReference.getFile().setGenerateSourceReport(true);
        RMIServiceModelService rmiService = new RMIServiceModelService(event.getGraphContext());
        if (javaClassModel != null) {
            RMIServiceModel rmiServiceModel = rmiService.getOrCreate(javaClassModel);
            JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
            for (JavaSourceFileModel source : javaClassService.getJavaSource(rmiServiceModel.getImplementationClass().getQualifiedName())) {
                source.setGenerateSourceReport(true);
            }
        }
    }

    public boolean isRemoteInterface(JavaClassModel jcm) {
        if (!jcm.isInterface().booleanValue()) {
            return false;
        }
        LOG.info("Class: " + jcm.getQualifiedName());
        for (JavaClassModel im : jcm.getInterfaces()) {
            if (StringUtils.equals((CharSequence)"java.rmi.Remote", (CharSequence)im.getQualifiedName())) {
                return true;
            }
            LOG.info(" - Implements: " + im.getQualifiedName());
        }
        if (jcm.getExtends() != null) {
            LOG.info(" - Extends: " + jcm.getExtends().getQualifiedName());
            return StringUtils.equals((CharSequence)"java.rmi.Remote", (CharSequence)jcm.getExtends().getQualifiedName());
        }
        return false;
    }

    private JavaClassModel getJavaClass(JavaTypeReferenceModel javaTypeReference) {
        JavaClassModel result = null;
        AbstractJavaSourceModel javaSource = javaTypeReference.getFile();
        for (JavaClassModel javaClassModel : javaSource.getJavaClasses()) {
            if (javaClassModel.isPublic() == null || !javaClassModel.isPublic().booleanValue()) continue;
            result = javaClassModel;
            break;
        }
        if (result == null) {
            result = (JavaClassModel)javaSource.getJavaClasses().iterator().next();
        }
        return result;
    }

    public String toString() {
        return "DiscoverEJBAnnotatedClasses";
    }
}

