/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.service;

import org.apache.commons.lang.StringUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.javaee.model.DataSourceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsConnectionFactoryModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationType;

public class JNDIResourceService
extends GraphService<JNDIResourceModel> {
    public JNDIResourceService(GraphContext context) {
        super(context, JNDIResourceModel.class);
    }

    public synchronized JNDIResourceModel createUnique(String jndiName) {
        JNDIResourceModel dataSource = (JNDIResourceModel)this.getUniqueByProperty("JNDI_LOCATION", jndiName);
        if (dataSource == null) {
            dataSource = (JNDIResourceModel)super.create();
            dataSource.setJndiLocation(jndiName);
        }
        return dataSource;
    }

    public void associateTypeJndiResource(JNDIResourceModel resource, String type) {
        if (type == null || resource == null) {
            return;
        }
        if (StringUtils.equals((String)type, (String)"javax.sql.DataSource") && !(resource instanceof DataSourceModel)) {
            DataSourceModel ds = (DataSourceModel)GraphService.addTypeToModel((GraphContext)this.getGraphContext(), (WindupVertexFrame)resource, DataSourceModel.class);
        } else if (StringUtils.equals((String)type, (String)"javax.jms.Queue") && !(resource instanceof JmsDestinationModel)) {
            JmsDestinationModel jms = (JmsDestinationModel)GraphService.addTypeToModel((GraphContext)this.getGraphContext(), (WindupVertexFrame)resource, JmsDestinationModel.class);
            jms.setDestinationType(JmsDestinationType.QUEUE);
        } else if (StringUtils.equals((String)type, (String)"javax.jms.QueueConnectionFactory") && !(resource instanceof JmsConnectionFactoryModel)) {
            JmsConnectionFactoryModel jms = (JmsConnectionFactoryModel)GraphService.addTypeToModel((GraphContext)this.getGraphContext(), (WindupVertexFrame)resource, JmsConnectionFactoryModel.class);
            jms.setConnectionFactoryType(JmsDestinationType.QUEUE);
        } else if (StringUtils.equals((String)type, (String)"javax.jms.Topic") && !(resource instanceof JmsDestinationModel)) {
            JmsDestinationModel jms = (JmsDestinationModel)GraphService.addTypeToModel((GraphContext)this.getGraphContext(), (WindupVertexFrame)resource, JmsDestinationModel.class);
            jms.setDestinationType(JmsDestinationType.TOPIC);
        } else if (StringUtils.equals((String)type, (String)"javax.jms.TopicConnectionFactory") && !(resource instanceof JmsConnectionFactoryModel)) {
            JmsConnectionFactoryModel jms = (JmsConnectionFactoryModel)GraphService.addTypeToModel((GraphContext)this.getGraphContext(), (WindupVertexFrame)resource, JmsConnectionFactoryModel.class);
            jms.setConnectionFactoryType(JmsDestinationType.TOPIC);
        }
    }
}

