/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.ClassUtilities;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.VertexFrame;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.InMemoryVertexFrame;
import org.jboss.windup.util.exception.WindupException;

public class FramedElementInMemory<T extends VertexFrame>
implements InvocationHandler {
    private final GraphContext context;
    private final Class<T> type;
    private final Map<String, Object> values = new HashMap<String, Object>();
    private static final Method attachMethod;
    private static final Method hashCodeMethod;
    private static final Method equalsMethod;
    private static final Method toStringMethod;

    public FramedElementInMemory(GraphContext graphContext, Class<T> type) {
        this.context = graphContext;
        this.type = type;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) {
        String propertyName;
        String methodName = method.getName();
        if (method.equals(hashCodeMethod)) {
            return this.hashCode();
        }
        if (method.equals(equalsMethod)) {
            return this.equals(arguments[0]);
        }
        if (method.equals(toStringMethod)) {
            return this.toString();
        }
        if (method.equals(attachMethod)) {
            this.attach();
            return null;
        }
        Property propertyAnnotation = method.getAnnotation(Property.class);
        if (propertyAnnotation == null) {
            Property windupPropertyAnnnotation = method.getAnnotation(Property.class);
            if (windupPropertyAnnnotation == null) {
                throw new WindupException("Method " + methodName + " called, but has no @Property annotation... only @Property methods are supported");
            }
            propertyName = windupPropertyAnnnotation.value();
        } else {
            propertyName = propertyAnnotation.value();
        }
        if (ClassUtilities.isGetMethod((Method)method)) {
            return this.values.get(propertyName);
        }
        if (ClassUtilities.isSetMethod((Method)method)) {
            Object value = arguments[0];
            if (value == null) {
                this.values.remove(propertyName);
            } else {
                this.values.put(propertyName, value);
            }
            return proxy;
        }
        if (ClassUtilities.isRemoveMethod((Method)method)) {
            this.values.remove(propertyName);
            return proxy;
        }
        throw new WindupException("Unrecognized method " + methodName + " called on in-memory Frame!");
    }

    private void attach() {
        VertexFrame element = (VertexFrame)this.context.getFramed().addVertex(null, this.type);
        Vertex v = element.asVertex();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            v.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return "[Proxy for: " + this.type.getCanonicalName() + ", values: " + this.values + "]";
    }

    static {
        try {
            attachMethod = InMemoryVertexFrame.class.getMethod("attachToGraph", new Class[0]);
            hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new WindupException(e.getMessage(), (Throwable)e);
        }
    }
}

