/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.util.datastructures.IterablesUtil;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.jboss.windup.graph.FramedElementInMemory;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.InMemoryVertexFrame;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.Service;
import org.jboss.windup.graph.service.exception.NonUniqueResultException;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Task;

public class GraphService<T extends WindupVertexFrame>
implements Service<T> {
    private Class<T> type;
    private GraphContext context;

    public GraphService(GraphContext context, Class<T> type) {
        this.context = context;
        this.type = type;
    }

    public static <T extends WindupVertexFrame> T refresh(GraphContext context, T frame) {
        return (T)((WindupVertexFrame)context.getFramed().frame(frame.asVertex(), WindupVertexFrame.class));
    }

    @Override
    public void commit() {
        ExecutionStatistics.performBenchmarked((String)"GraphService.commit", (Task)new Task<Void>(){

            public Void execute() {
                ((TitanGraph)GraphService.this.getGraphContext().getGraph().getBaseGraph()).commit();
                return null;
            }
        });
    }

    @Override
    public long count(final Iterable<?> obj) {
        return (Long)ExecutionStatistics.performBenchmarked((String)"GraphService.count", (Task)new Task<Long>(){

            public Long execute() throws BuildException {
                GremlinPipeline pipe = new GremlinPipeline();
                long result = pipe.start((Object)obj).count();
                return result;
            }
        });
    }

    @Override
    public T createInMemory() {
        Class[] resolvedTypes = new Class[]{VertexFrame.class, InMemoryVertexFrame.class, this.type};
        return (T)((WindupVertexFrame)Proxy.newProxyInstance(this.type.getClassLoader(), resolvedTypes, new FramedElementInMemory<T>(this.context, this.type)));
    }

    @Override
    public T create() {
        return (T)((WindupVertexFrame)ExecutionStatistics.performBenchmarked((String)"GraphService.create", (Task)new Task<T>(){

            public T execute() throws BuildException {
                return (WindupVertexFrame)GraphService.this.context.getFramed().addVertex(null, GraphService.this.type);
            }
        }));
    }

    @Override
    public T addTypeToModel(final WindupVertexFrame model) {
        return (T)((WindupVertexFrame)ExecutionStatistics.performBenchmarked((String)"GraphService.addTypeToModel", (Task)new Task<T>(){

            public T execute() throws BuildException {
                return GraphService.addTypeToModel(GraphService.this.getGraphContext(), model, GraphService.this.type);
            }
        }));
    }

    protected FramedGraphQuery findAllQuery() {
        return this.context.getQuery().type(this.type);
    }

    @Override
    public Iterable<T> findAll() {
        return this.findAllQuery().vertices(this.type);
    }

    @Override
    public Iterable<T> findAllByProperties(final String[] keys, final String[] vals) {
        return (Iterable)ExecutionStatistics.performBenchmarked((String)("GraphService.findAllByProperties(" + Arrays.asList(keys) + ")"), (Task)new Task<Iterable<T>>(){

            public Iterable<T> execute() throws BuildException {
                FramedGraphQuery query = GraphService.this.findAllQuery();
                int j = keys.length;
                for (int i = 0; i < j; ++i) {
                    String key = keys[i];
                    String val = vals[i];
                    query = query.has(key, (Object)val);
                }
                return query.vertices(GraphService.this.type);
            }
        });
    }

    @Override
    public Iterable<T> findAllByProperty(final String key, final Object value) {
        return (Iterable)ExecutionStatistics.performBenchmarked((String)("GraphService.findAllByProperty(" + key + ")"), (Task)new Task<Iterable<T>>(){

            public Iterable<T> execute() throws BuildException {
                return GraphService.this.context.getFramed().getVertices(key, value, GraphService.this.type);
            }
        });
    }

    @Override
    public Iterable<T> findAllWithoutProperty(final String key, final Object value) {
        return (Iterable)ExecutionStatistics.performBenchmarked((String)("GraphService.findAllWithoutProperty(" + key + ")"), (Task)new Task<Iterable<T>>(){

            public Iterable<T> execute() throws BuildException {
                return GraphService.this.findAllQuery().hasNot(key, value).vertices(GraphService.this.type);
            }
        });
    }

    @Override
    public Iterable<T> findAllWithoutProperty(final String key) {
        return (Iterable)ExecutionStatistics.performBenchmarked((String)("GraphService.findAllWithoutProperty(" + key + ")"), (Task)new Task<Iterable<T>>(){

            public Iterable<T> execute() throws BuildException {
                return GraphService.this.findAllQuery().hasNot(key).vertices(GraphService.this.type);
            }
        });
    }

    @Override
    public Iterable<T> findAllByPropertyMatchingRegex(final String key, final String ... regex) {
        return (Iterable)ExecutionStatistics.performBenchmarked((String)("GraphService.findAllByPropertyMatchingRegex(" + key + ")"), (Task)new Task<Iterable<T>>(){

            public Iterable<T> execute() throws BuildException {
                String regexFinal;
                if (regex.length == 0) {
                    return IterablesUtil.emptyIterable();
                }
                if (regex.length == 1) {
                    regexFinal = regex[0];
                } else {
                    StringBuilder builder = new StringBuilder();
                    builder.append("\\b(");
                    int i = 0;
                    for (String value : regex) {
                        if (i > 0) {
                            builder.append("|");
                        }
                        builder.append(value);
                        ++i;
                    }
                    builder.append(")\\b");
                    regexFinal = builder.toString();
                }
                return GraphService.this.findAllQuery().has(key, (Predicate)Text.REGEX, (Object)regexFinal).vertices(GraphService.this.type);
            }
        });
    }

    @Override
    public T getById(Object id) {
        return (T)((WindupVertexFrame)this.context.getFramed().getVertex(id, this.type));
    }

    @Override
    public T frame(Vertex vertex) {
        return (T)((WindupVertexFrame)this.getGraphContext().getFramed().frame(vertex, this.getType()));
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    protected GraphQuery getTypedQuery() {
        return this.getGraphContext().getQuery().type(this.type);
    }

    protected String getTypeValueForSearch() {
        TypeValue typeValue = this.type.getAnnotation(TypeValue.class);
        if (typeValue == null) {
            throw new IllegalArgumentException("Must be annotated with '@TypeValue': " + this.type.getName());
        }
        return typeValue.value();
    }

    @Override
    public T getUnique() throws NonUniqueResultException {
        Iterable<T> results = this.findAll();
        if (!results.iterator().hasNext()) {
            return null;
        }
        Iterator<T> iterator = results.iterator();
        WindupVertexFrame result = (WindupVertexFrame)iterator.next();
        if (iterator.hasNext()) {
            throw new NonUniqueResultException("Expected unique value, but returned non-unique.");
        }
        return (T)result;
    }

    @Override
    public T getUniqueByProperty(String property, Object value) throws NonUniqueResultException {
        Iterable<T> results = this.findAllByProperty(property, value);
        if (!results.iterator().hasNext()) {
            return null;
        }
        Iterator<T> iterator = results.iterator();
        WindupVertexFrame result = (WindupVertexFrame)iterator.next();
        if (iterator.hasNext()) {
            throw new NonUniqueResultException("Expected unique value, but returned non-unique.");
        }
        return (T)result;
    }

    protected T getUnique(GraphQuery framedQuery) {
        Iterable results = framedQuery.vertices();
        if (!results.iterator().hasNext()) {
            return null;
        }
        Iterator iter = results.iterator();
        Vertex result = (Vertex)iter.next();
        if (iter.hasNext()) {
            throw new NonUniqueResultException("Expected unique value, but returned non-unique.");
        }
        return (T)this.frame(result);
    }

    protected GraphContext getGraphContext() {
        return this.context;
    }

    @Override
    public TitanTransaction newTransaction() {
        return ((TitanGraph)this.context.getGraph().getBaseGraph()).newTransaction();
    }

    public static <T extends WindupVertexFrame> T addTypeToModel(GraphContext graphContext, WindupVertexFrame frame, Class<T> type) {
        Vertex vertex = frame.asVertex();
        graphContext.getGraphTypeRegistry().addTypeToElement(type, (Element)vertex);
        return (T)((WindupVertexFrame)graphContext.getFramed().frame(vertex, type));
    }

    public static <T extends WindupVertexFrame> T removeTypeFromModel(GraphContext graphContext, WindupVertexFrame frame, Class<T> type) {
        Vertex vertex = frame.asVertex();
        graphContext.getGraphTypeRegistry().removeTypeFromElement(type, (Element)vertex);
        return (T)((WindupVertexFrame)graphContext.getFramed().frame(vertex, type));
    }

    @Override
    public void remove(final T model) {
        ExecutionStatistics.performBenchmarked((String)"GraphService.commit", (Task)new Task<Void>(){

            public Void execute() {
                model.asVertex().remove();
                return null;
            }
        });
    }
}

