/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.role;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.mapping.providers.role.SecurityActions;

public class Util {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadProperties(String propertiesName, Logger log) throws IOException {
        URL url;
        Properties bundle;
        boolean trace;
        block18: {
            trace = log.isTraceEnabled();
            bundle = null;
            ClassLoader loader = SecurityActions.getContextClassLoader();
            url = null;
            if (loader instanceof URLClassLoader) {
                URLClassLoader ucl = (URLClassLoader)loader;
                url = SecurityActions.findResource(ucl, propertiesName);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("findResource: " + url));
                }
            }
            if (url == null) {
                url = loader.getResource(propertiesName);
            }
            if (url == null) {
                try {
                    url = new URL(propertiesName);
                }
                catch (MalformedURLException mue) {
                    File tmp;
                    if (trace) {
                        log.trace((Object)"Failed to open properties as URL", (Throwable)mue);
                    }
                    if (!(tmp = new File(propertiesName)).exists()) break block18;
                    url = tmp.toURI().toURL();
                }
            }
        }
        if (url == null) {
            String msg = "No properties file " + propertiesName + " found";
            throw new IOException(msg);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Properties file=" + url));
        }
        Properties defaults = new Properties();
        bundle = new Properties(defaults);
        InputStream is = null;
        try {
            is = SecurityActions.openStream(url);
        }
        catch (PrivilegedActionException e) {
            if (trace) {
                log.trace((Object)"Open stream error", (Throwable)e);
            }
            throw new IOException(e.getLocalizedMessage());
        }
        if (is != null) {
            try {
                bundle.load(is);
            }
            finally {
                Util.safeClose(is);
            }
        } else {
            throw new IOException("PB00023: Missing File:Properties file " + propertiesName + " not available");
        }
        if (trace) {
            log.debug((Object)("Loaded properties, keySet=" + bundle.keySet()));
        }
        return bundle;
    }

    static void addRolesToGroup(String username, RoleGroup roleGroup, Properties roles, Logger log) {
        boolean trace = log.isTraceEnabled();
        String[] roleNames = null;
        if (roles.containsKey(username)) {
            String value = roles.getProperty(username);
            if (trace) {
                log.trace((Object)("Adding to RoleGroup: " + value));
            }
            roleNames = Util.parseRoles(value);
        }
        if (roleNames != null) {
            for (int i = 0; i < roleNames.length; ++i) {
                roleGroup.addRole(new SimpleRole(roleNames[i]));
            }
        }
    }

    static String[] parseRoles(String roles) {
        return roles.split(",");
    }

    static void addRolesToGroup(String username, RoleGroup roleGroup, String dsJndiName, String rolesQuery, Logger log, boolean suspendResume, TransactionManager tm) {
        boolean trace = log.isTraceEnabled();
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        if (suspendResume && tm == null) {
            throw new IllegalStateException("PB00015: Null Value:Transaction Manager is null");
        }
        Transaction tx = null;
        if (suspendResume) {
            try {
                tx = tm.suspend();
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
            if (trace) {
                log.trace((Object)"suspendAnyTransaction");
            }
        }
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(dsJndiName);
            conn = ds.getConnection();
            if (trace) {
                log.trace((Object)("Excuting query: " + rolesQuery + ", with username: " + username));
            }
            ps = conn.prepareStatement(rolesQuery);
            try {
                ps.setString(1, username);
            }
            catch (ArrayIndexOutOfBoundsException ignore) {
                // empty catch block
            }
            rs = ps.executeQuery();
            if (!rs.next() && trace) {
                log.trace((Object)"No roles found");
            }
            do {
                String name = rs.getString(1);
                roleGroup.addRole(new SimpleRole(name));
            } while (rs.next());
        }
        catch (NamingException ex) {
            throw new IllegalArgumentException("PB00019: Processing Failed:Error looking up DataSource from: " + dsJndiName, ex);
        }
        catch (SQLException ex) {
            throw new IllegalArgumentException("PB00019: Processing Failed:Query failed", ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
            if (suspendResume) {
                try {
                    tm.resume(tx);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (trace) {
                    log.trace((Object)"resumeAnyTransaction");
                }
            }
        }
    }

    private static void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

