/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.predicates;

import java.util.HashSet;
import java.util.Set;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.RuleProvider;

public class EnumeratedRuleProviderPredicate
implements Predicate<RuleProvider> {
    private final Set<Class<? extends RuleProvider>> enabledProviders = new HashSet<Class<? extends RuleProvider>>();

    @SafeVarargs
    public EnumeratedRuleProviderPredicate(Class<? extends RuleProvider> provider, Class<? extends RuleProvider> ... providers) {
        if (provider != null) {
            this.enabledProviders.add(provider);
        }
        for (Class<? extends RuleProvider> p : providers) {
            this.enabledProviders.add(p);
        }
    }

    public boolean accept(RuleProvider provider) {
        Class<?> clazz = provider.getClass();
        for (Class<? extends RuleProvider> enabledClazz : this.enabledProviders) {
            if (!enabledClazz.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

