/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.IngresDialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.type.StandardBasicTypes;

public class Ingres9Dialect
extends IngresDialect {
    public Ingres9Dialect() {
        this.registerDateTimeFunctions();
        this.registerDateTimeColumnTypes();
        this.registerFunction("concat", new VarArgsSQLFunction(StandardBasicTypes.STRING, "(", "||", ")"));
    }

    protected void registerDateTimeFunctions() {
        this.registerFunction("current_time", new NoArgSQLFunction("current_time", StandardBasicTypes.TIME, false));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", StandardBasicTypes.DATE, false));
    }

    protected void registerDateTimeColumnTypes() {
        this.registerColumnType(91, "ansidate");
        this.registerColumnType(93, "timestamp(9) with time zone");
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean forUpdateOfColumns() {
        return true;
    }

    @Override
    public String getIdentitySelectString() {
        return "select last_identity()";
    }

    @Override
    public String getQuerySequencesString() {
        return "select seq_name from iisequences";
    }

    @Override
    public boolean supportsPooledSequences() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    @Override
    public String getCurrentTimestampSQLFunctionName() {
        return "current_timestamp";
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    @Override
    public boolean supportsLimitOffset() {
        return true;
    }

    @Override
    public boolean supportsVariableLimit() {
        return false;
    }

    @Override
    public boolean useMaxForLimit() {
        return false;
    }

    @Override
    public String getLimitString(String querySelect, int offset, int limit) {
        StringBuffer soff = new StringBuffer(" offset " + offset);
        StringBuffer slim = new StringBuffer(" fetch first " + limit + " rows only");
        StringBuffer sb = new StringBuffer(querySelect.length() + soff.length() + slim.length()).append(querySelect);
        if (offset > 0) {
            sb.append(soff);
        }
        if (limit > 0) {
            sb.append(slim);
        }
        return sb.toString();
    }
}

