/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import org.xadisk.bridge.proxies.impl.RemoteTransactionInformation;
import org.xadisk.filesystem.ConcurrencyControl;
import org.xadisk.filesystem.FileSystemConfiguration;
import org.xadisk.filesystem.Lock;
import org.xadisk.filesystem.LockTreeNode;
import org.xadisk.filesystem.NativeLock;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.ResourceDependencyGraph;
import org.xadisk.filesystem.TransactionInformation;
import org.xadisk.filesystem.exceptions.AncestorPinnedException;
import org.xadisk.filesystem.exceptions.DeadLockVictimizedException;
import org.xadisk.filesystem.exceptions.DirectoryPinningFailedException;
import org.xadisk.filesystem.exceptions.LockingFailedException;
import org.xadisk.filesystem.exceptions.LockingTimedOutException;
import org.xadisk.filesystem.exceptions.TransactionRolledbackException;
import org.xadisk.filesystem.exceptions.TransactionTimeoutException;
import org.xadisk.filesystem.workers.DeadLockDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeConcurrencyControl
implements ConcurrencyControl {
    private final ResourceDependencyGraph resourceDependencyGraph = new ResourceDependencyGraph();
    private final WorkManager workManager;
    private final DeadLockDetector deadLockDetector;
    private final LockTreeNode rootNode;

    public NativeConcurrencyControl(FileSystemConfiguration configuration, WorkManager workManager, WorkListener workListener, NativeXAFileSystem nativeXAFileSystem) throws WorkException {
        this.deadLockDetector = new DeadLockDetector(configuration.getDeadLockDetectorInterval(), this.resourceDependencyGraph, nativeXAFileSystem, this);
        this.workManager = workManager;
        this.rootNode = new LockTreeNode(null, false);
        this.workManager.startWork((Work)this.deadLockDetector, Long.MAX_VALUE, null, workListener);
    }

    @Override
    public Lock acquireFileLock(TransactionInformation requestor, File f, long time, boolean exclusive) throws LockingFailedException, InterruptedException, TransactionRolledbackException, DeadLockVictimizedException, TransactionTimeoutException {
        if (exclusive) {
            return this.acquireExclusiveLock(requestor, f, time);
        }
        return this.acquireSharedLock(requestor, f, time);
    }

    private LockTreeNode traverseDownToFileNode(File f, boolean checkForPins, TransactionInformation requestor) throws AncestorPinnedException {
        ArrayList<String> pathElements = new ArrayList<String>();
        File currentFile = f;
        while (currentFile != null) {
            File parentFile = currentFile.getParentFile();
            if (parentFile == null) {
                pathElements.add(currentFile.getAbsolutePath());
            } else {
                pathElements.add(currentFile.getName());
            }
            currentFile = parentFile;
        }
        LockTreeNode currentNode = this.rootNode;
        ArrayList<LockTreeNode> nodesOnPath = new ArrayList<LockTreeNode>();
        for (int i = pathElements.size() - 1; i >= 0; --i) {
            currentNode = currentNode.getChild((String)pathElements.get(i));
            nodesOnPath.add(currentNode);
        }
        if (checkForPins) {
            for (LockTreeNode nodeOnPath : nodesOnPath) {
                if (!nodeOnPath.isPinnedByOtherTransaction(requestor)) continue;
                throw new AncestorPinnedException(f.getAbsolutePath(), nodeOnPath.getPath().getAbsolutePath());
            }
        }
        return currentNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock acquireSharedLock(TransactionInformation requestor, File f, long time) throws LockingFailedException, InterruptedException, TransactionRolledbackException, DeadLockVictimizedException, TransactionTimeoutException {
        LockTreeNode fileNode = this.traverseDownToFileNode(f, true, requestor);
        NativeLock lock = fileNode.getLock();
        try {
            lock.startSynchBlock();
            long remainingTime = time;
            boolean indefiniteWait = time == 0L;
            this.resourceDependencyGraph.addDependency(requestor, lock);
            while (lock.isExclusive()) {
                try {
                    long now1 = System.currentTimeMillis();
                    lock.waitTillReadable(remainingTime);
                    if (lock.isExclusive()) {
                        long now2 = System.currentTimeMillis();
                        if (indefiniteWait || (remainingTime -= now2 - now1) > 0L) continue;
                        this.removeDependencyFromRDG(requestor);
                        throw new LockingTimedOutException(f.getAbsolutePath());
                    }
                    break;
                }
                catch (InterruptedException ie) {
                    byte interruptCause = requestor.getNodeInResourceDependencyGraph().getInterruptCause();
                    this.removeDependencyFromRDG(requestor);
                    if (interruptCause == 1) {
                        throw new DeadLockVictimizedException(f.getAbsolutePath());
                    }
                    if (interruptCause == 2) {
                        throw new TransactionTimeoutException();
                    }
                    throw ie;
                }
            }
            this.removeDependencyFromRDG(requestor);
            this.resolveConcurrenyWithDirectoryPin(lock, fileNode, requestor);
            NativeLock nativeLock = lock;
            return nativeLock;
        }
        finally {
            lock.endSynchBlock();
        }
    }

    private void resolveConcurrenyWithDirectoryPin(NativeLock lock, LockTreeNode fileNode, TransactionInformation requestor) throws AncestorPinnedException {
        lock.addHolder(requestor);
        if (fileNode.isPinnedByOtherTransaction(requestor)) {
            lock.removeHolder(requestor);
            throw new AncestorPinnedException(fileNode.getPath().getAbsolutePath(), "<unknown>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock acquireExclusiveLock(TransactionInformation requestor, File f, long time) throws LockingFailedException, InterruptedException, TransactionRolledbackException, DeadLockVictimizedException, TransactionTimeoutException {
        LockTreeNode fileNode = this.traverseDownToFileNode(f, true, requestor);
        NativeLock lock = fileNode.getLock();
        try {
            lock.startSynchBlock();
            if (this.canUpgradeLock(lock, requestor)) {
                lock.setExclusive(true);
                lock.markUpgraded();
                NativeLock nativeLock = lock;
                return nativeLock;
            }
            long remainingTime = time;
            boolean indefiniteWait = time == 0L;
            this.resourceDependencyGraph.addDependency(requestor, lock);
            while (lock.getNumHolders() != 0 && !this.canUpgradeLock(lock, requestor)) {
                try {
                    long now1 = System.currentTimeMillis();
                    lock.waitTillWritable(remainingTime);
                    if (lock.getNumHolders() != 0 && !this.canUpgradeLock(lock, requestor)) {
                        long now2 = System.currentTimeMillis();
                        if (indefiniteWait || (remainingTime -= now2 - now1) > 0L) continue;
                        this.removeDependencyFromRDG(requestor);
                        throw new LockingTimedOutException(f.getAbsolutePath());
                    }
                    break;
                }
                catch (InterruptedException ie) {
                    byte interruptCause = requestor.getNodeInResourceDependencyGraph().getInterruptCause();
                    this.removeDependencyFromRDG(requestor);
                    if (interruptCause == 1) {
                        throw new DeadLockVictimizedException(f.getAbsolutePath());
                    }
                    if (interruptCause == 2) {
                        throw new TransactionTimeoutException();
                    }
                    throw ie;
                }
            }
            this.removeDependencyFromRDG(requestor);
            if (this.canUpgradeLock(lock, requestor)) {
                lock.markUpgraded();
            } else {
                this.resolveConcurrenyWithDirectoryPin(lock, fileNode, requestor);
            }
            lock.setExclusive(true);
            NativeLock nativeLock = lock;
            return nativeLock;
        }
        finally {
            lock.endSynchBlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLock(TransactionInformation releasor, Lock lock) {
        NativeLock nativeLock = (NativeLock)lock;
        try {
            nativeLock.startSynchBlock();
            nativeLock.removeHolder(releasor);
            if (nativeLock.isExclusive()) {
                nativeLock.reset();
                nativeLock.notifyReadWritable();
            } else {
                nativeLock.notifyWritable();
            }
        }
        finally {
            nativeLock.endSynchBlock();
        }
    }

    @Override
    public void releaseRenamePinOnDirectories(ArrayList<File> dirs) {
        for (File dir : dirs) {
            this.releaseRenamePinOnDirectory(dir);
        }
    }

    @Override
    public void releaseRenamePinOnDirectory(File dir) {
        try {
            LockTreeNode dirNode = this.traverseDownToFileNode(dir, false, null);
            this.unpinDirectoryTree(dirNode);
        }
        catch (AncestorPinnedException ancestorPinnedException) {
            // empty catch block
        }
    }

    private void unpinDirectoryTree(LockTreeNode dirNode) {
        LockTreeNode[] children;
        dirNode.releasePin();
        for (LockTreeNode child : children = dirNode.getAllChildren()) {
            child.releasePin();
            this.unpinDirectoryTree(child);
        }
    }

    @Override
    public void pinDirectoryForRename(File dir, TransactionInformation requestor) throws DirectoryPinningFailedException, AncestorPinnedException {
        LockTreeNode dirNode = this.traverseDownToFileNode(dir, true, requestor);
        this.pinDirectoryTree(dirNode, requestor, dir.getAbsolutePath());
    }

    private void pinDirectoryTree(LockTreeNode dirNode, TransactionInformation requestor, String dirToRename) throws DirectoryPinningFailedException {
        this.pinLockTreeNode(dirNode, requestor, dirToRename);
        LockTreeNode[] children = dirNode.getAllChildren();
        try {
            for (LockTreeNode child : children) {
                try {
                    this.pinDirectoryTree(child, requestor, dirToRename);
                }
                catch (DirectoryPinningFailedException dpfe) {
                    child.releasePin();
                    throw dpfe;
                }
            }
        }
        catch (DirectoryPinningFailedException dpfe) {
            dirNode.releasePin();
            throw dpfe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pinLockTreeNode(LockTreeNode node, TransactionInformation requestor, String dirToRename) throws DirectoryPinningFailedException {
        TransactionInformation[] holders;
        if (node.isPinnedByOtherTransaction(requestor)) {
            throw new DirectoryPinningFailedException(dirToRename, node.getPath().getAbsolutePath());
        }
        if (!node.attemptPinning(requestor)) {
            throw new DirectoryPinningFailedException(dirToRename, node.getPath().getAbsolutePath());
        }
        NativeLock lock = node.getLock();
        try {
            lock.startSynchBlock();
            HashSet<TransactionInformation> holdersSet = lock.getHolders();
            holders = holdersSet.toArray(new TransactionInformation[0]);
        }
        finally {
            lock.endSynchBlock();
        }
        for (int i = 0; i < holders.length; ++i) {
            if (holders[i].equals(requestor)) continue;
            node.releasePin();
            throw new DirectoryPinningFailedException(dirToRename, node.getPath().getAbsolutePath());
        }
    }

    private boolean canUpgradeLock(NativeLock lock, TransactionInformation requestor) {
        return lock.getNumHolders() == 1 && lock.isAHolder(requestor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDependencyFromRDG(TransactionInformation requestor) {
        ResourceDependencyGraph.Node node = requestor.getNodeInResourceDependencyGraph();
        Object object = node.getInterruptFlagLock();
        synchronized (object) {
            this.resourceDependencyGraph.removeDependency(requestor);
            if (node.getInterruptCause() != 0) {
                Thread.interrupted();
            }
        }
    }

    public ResourceDependencyGraph getResourceDependencyGraph() {
        return this.resourceDependencyGraph;
    }

    @Override
    public void shutdown() {
        this.deadLockDetector.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interruptTransactionIfWaitingForResourceLock(TransactionInformation xid, byte cause) {
        ResourceDependencyGraph.Node node1 = this.getNodeForTransaction(xid);
        if (node1 != null) {
            Object object = node1.getInterruptFlagLock();
            synchronized (object) {
                ResourceDependencyGraph.Node node2 = this.getNodeForTransaction(xid);
                if (node1 == node2) {
                    node1.setInterruptCause(cause);
                    node1.getThreadWaitingForLock().interrupt();
                }
            }
        }
    }

    private ResourceDependencyGraph.Node getNodeForTransaction(TransactionInformation xid) {
        if (xid instanceof RemoteTransactionInformation) {
            return this.resourceDependencyGraph.getNode(xid);
        }
        return xid.getNodeInResourceDependencyGraph();
    }
}

