/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.Set;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.TagUtil;
import org.jboss.windup.reporting.freemarker.FreeMarkerUtil;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.model.ReportFileModel;
import org.jboss.windup.reporting.model.source.SourceReportModel;
import org.jboss.windup.reporting.service.SourceReportService;
import org.jboss.windup.util.ExecutionStatistics;

public class IsReportableFile
implements WindupFreeMarkerMethod {
    public static final String NAME = "isReportableFile";
    private SourceReportService sourceReportService;

    public void setContext(GraphRewrite event) {
        this.sourceReportService = new SourceReportService(event.getGraphContext());
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a " + FileModel.class.getSimpleName() + " and a set of tags to include and exclude as parameters, and whether or not this file should appear in overview reports";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        try {
            if (arguments.size() != 3) {
                throw new TemplateModelException("Error, method expects one argument (FileModel, includeTags:Set<String>, excludeTags:Set<String>)");
            }
            StringModel stringModelArg = (StringModel)arguments.get(0);
            FileModel fileModel = (FileModel)stringModelArg.getWrappedObject();
            Set includeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)((SimpleSequence)arguments.get(1)));
            Set excludeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)((SimpleSequence)arguments.get(2)));
            SourceReportModel result = this.sourceReportService.getSourceReportForFileModel(fileModel);
            if (result == null) {
                Boolean bl = false;
                return bl;
            }
            Boolean bl = TagUtil.hasHintsOrClassificationsWithRelevantTags((ReportFileModel)result.getSourceFileModel(), (Set)includeTags, (Set)excludeTags);
            return bl;
        }
        finally {
            ExecutionStatistics.get().end(NAME);
        }
    }
}

