/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.util.Logging;
import org.pegdown.LinkRenderer;
import org.pegdown.PegDownProcessor;
import org.pegdown.ToHtmlSerializer;
import org.pegdown.ast.RootNode;
import org.pegdown.plugins.PegDownPlugins;

public class MarkdownToHtmlMethod
implements WindupFreeMarkerMethod {
    private static final Logger LOG = Logging.get(MarkdownToHtmlMethod.class);
    public static final long MAX_PARSING_TIME_MILLIS = 10000L;

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (String)");
        }
        SimpleScalar freemarkerArg = (SimpleScalar)arguments.get(0);
        String markdownSource = freemarkerArg.getAsString();
        try {
            PegDownPlugins plugins = PegDownPlugins.builder().build();
            PegDownProcessor processor = new PegDownProcessor(128, 10000L, plugins);
            RootNode outputNode = processor.parseMarkdown(markdownSource.toCharArray());
            ArrayList serializerPlugins = new ArrayList(1);
            ToHtmlSerializer serializer = new ToHtmlSerializer(new LinkRenderer(), Collections.emptyMap(), serializerPlugins);
            return serializer.toHtml(outputNode);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Failed to parse markdown due to: " + t.getMessage() + " markdown source: " + markdownSource, t);
            return markdownSource;
        }
    }

    public String getMethodName() {
        return "markdownToHtml";
    }

    public String getDescription() {
        return "Converts from an input string in Markdown format to an output string in HTML format";
    }

    public void setContext(GraphRewrite event) {
    }
}

