/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.ext.beans.BeanModel;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.comparator.FilePathComparator;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.exception.WindupException;

public class SortFilesByPathMethod
implements WindupFreeMarkerMethod {
    private static final String NAME = "sortFilesByPathAscending";

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes an Iterable<" + FileModel.class.getSimpleName() + "> and returns them, ordered alphabetically.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (Iterable<FileModel>)");
        }
        Iterable<FileModel> fileModelIterable = this.getList(arguments.get(0));
        ArrayList<FileModel> fileModelList = new ArrayList<FileModel>();
        for (FileModel fm : fileModelIterable) {
            fileModelList.add(fm);
        }
        final FilePathComparator filePathComparator = new FilePathComparator();
        Collections.sort(fileModelList, new Comparator<FileModel>(){

            @Override
            public int compare(FileModel o1, FileModel o2) {
                return filePathComparator.compare(o1.getFilePath(), o2.getFilePath());
            }
        });
        ExecutionStatistics.get().end(NAME);
        return fileModelList;
    }

    private Iterable<FileModel> getList(Object arg) throws TemplateModelException {
        if (arg instanceof BeanModel) {
            BeanModel beanModel = (BeanModel)arg;
            return (Iterable)beanModel.getWrappedObject();
        }
        if (arg instanceof SimpleSequence) {
            SimpleSequence simpleSequence = (SimpleSequence)arg;
            return simpleSequence.toList();
        }
        throw new WindupException("Unrecognized type passed to: " + this.getMethodName() + ": " + arg.getClass().getCanonicalName());
    }

    public void setContext(GraphRewrite event) {
    }
}

