/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.HashSet;
import org.jboss.forge.furnace.util.Iterators;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.model.TechnologyTagModel;

public class TechnologyTagService
extends GraphService<TechnologyTagModel> {
    public TechnologyTagService(GraphContext context) {
        super(context, TechnologyTagModel.class);
    }

    public TechnologyTagModel addTagToFileModel(FileModel fileModel, String tagName, TechnologyTagLevel level) {
        FramedGraphQuery q = this.getGraphContext().getQuery().type(TechnologyTagModel.class).has("name", (Object)tagName);
        TechnologyTagModel technologyTag = (TechnologyTagModel)super.getUnique((GraphQuery)q);
        if (technologyTag == null) {
            technologyTag = (TechnologyTagModel)this.create();
            technologyTag.setName(tagName);
            technologyTag.setLevel(level);
        }
        technologyTag.addFileModel(fileModel);
        return technologyTag;
    }

    public void removeTagFromFileModel(FileModel fileModel, String tagName) {
        FramedGraphQuery q = this.getGraphContext().getQuery().type(TechnologyTagModel.class).has("name", (Object)tagName);
        TechnologyTagModel technologyTag = (TechnologyTagModel)super.getUnique((GraphQuery)q);
        if (technologyTag != null) {
            technologyTag.removeFileModel(fileModel);
        }
    }

    public Iterable<TechnologyTagModel> findTechnologyTagsForFile(FileModel fileModel) {
        GremlinPipeline pipeline = new GremlinPipeline((Object)fileModel.asVertex());
        pipeline.in(new String[]{"techTagToFileModel"}).has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"TechnologyTag");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)pipeline, TechnologyTagModel.class);
    }

    public Iterable<TechnologyTagModel> findTechnologyTagsForProject(ProjectModel projectModel) {
        HashSet<TechnologyTagModel> results = new HashSet<TechnologyTagModel>();
        GremlinPipeline pipeline = new GremlinPipeline((Object)projectModel.asVertex());
        pipeline.out(new String[]{"projectModelToFile"});
        pipeline.in(new String[]{"techTagToFileModel"}).has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"TechnologyTag");
        FramedVertexIterable modelIterable = new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)pipeline, TechnologyTagModel.class);
        results.addAll(Iterators.asSet((Iterable)modelIterable));
        for (ProjectModel childProjectModel : projectModel.getChildProjects()) {
            results.addAll(Iterators.asSet(this.findTechnologyTagsForProject(childProjectModel)));
        }
        return results;
    }
}

