/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.PreReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.LinkService;
import org.jboss.windup.reporting.model.association.LinkableModel;
import org.jboss.windup.rules.apps.javaee.model.DataSourceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ResolveServerResourceLinksRuleProvider
extends IteratingRuleProvider<JNDIResourceModel> {
    private static final Logger LOG = Logging.get(ResolveServerResourceLinksRuleProvider.class);

    public ResolveServerResourceLinksRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ResolveServerResourceLinksRuleProvider.class, (String)"Resolve Links to Server Documentation").setPhase(PreReportGenerationPhase.class));
    }

    public ConditionBuilder when() {
        return Query.fromType(JNDIResourceModel.class);
    }

    public void perform(GraphRewrite event, EvaluationContext context, JNDIResourceModel payload) {
        if (payload instanceof DataSourceModel) {
            this.processDataSource(event.getGraphContext(), (DataSourceModel)payload);
        } else if (payload instanceof JmsDestinationModel) {
            this.processJMSDestination(event.getGraphContext(), (JmsDestinationModel)payload);
        }
    }

    private void processJMSDestination(GraphContext context, JmsDestinationModel destination) {
        LinkService linkService = new LinkService(context);
        LinkableModel linkable = (LinkableModel)GraphService.addTypeToModel((GraphContext)context, (WindupVertexFrame)destination, LinkableModel.class);
        LinkModel jmsDestinationLink = linkService.getOrCreate("Destination Setup", "https://access.redhat.com/documentation/en-US/JBoss_Enterprise_Application_Platform/6.4/html/Administration_and_Configuration_Guide/sect-Configuration.html");
        linkable.addLink(jmsDestinationLink);
    }

    private void processDataSource(GraphContext context, DataSourceModel dataSource) {
        LinkModel lnk;
        LinkService linkService = new LinkService(context);
        LinkableModel linkable = (LinkableModel)GraphService.addTypeToModel((GraphContext)context, (WindupVertexFrame)dataSource, LinkableModel.class);
        if (StringUtils.equals((String)"Oracle", (String)dataSource.getDatabaseTypeName())) {
            LinkModel eap6OracleLink = linkService.getOrCreate("Oracle DataSource Setup", "https://access.redhat.com/documentation/en-US/JBoss_Enterprise_Application_Platform/6.4/html/Administration_and_Configuration_Guide/sect-Example_Datasources.html#Example_Oracle_Datasource");
            linkable.addLink(eap6OracleLink);
        } else if (StringUtils.equals((String)"MySQL", (String)dataSource.getDatabaseTypeName())) {
            lnk = linkService.getOrCreate("MySQL DataSource Setup", "https://access.redhat.com/documentation/en-US/JBoss_Enterprise_Application_Platform/6.4/html/Administration_and_Configuration_Guide/sect-Example_Datasources.html#Example_MySQL_Datasource1");
            linkable.addLink(lnk);
        } else if (StringUtils.equals((String)"Postgres", (String)dataSource.getDatabaseTypeName())) {
            lnk = linkService.getOrCreate("Postgres DataSource Setup", "https://access.redhat.com/documentation/en-US/JBoss_Enterprise_Application_Platform/6.4/html/Administration_and_Configuration_Guide/sect-Example_Datasources.html#Example_PostgreSQL_Datasource1");
            linkable.addLink(lnk);
        } else if (StringUtils.equals((String)"SqlServer", (String)dataSource.getDatabaseTypeName())) {
            lnk = linkService.getOrCreate("SqlServer DataSource Setup", "https://access.redhat.com/documentation/en-US/JBoss_Enterprise_Application_Platform/6.4/html/Administration_and_Configuration_Guide/sect-Example_Datasources.html#Example_Microsoft_SQLServer_Datasource1");
            linkable.addLink(lnk);
        } else if (StringUtils.equals((String)"DB2", (String)dataSource.getDatabaseTypeName())) {
            lnk = linkService.getOrCreate("DB2 DataSource Setup", "https://access.redhat.com/documentation/en-US/JBoss_Enterprise_Application_Platform/6.4/html/Administration_and_Configuration_Guide/sect-Example_Datasources.html#Example_IBM_DB2_Datasource");
            linkable.addLink(lnk);
        } else if (StringUtils.equals((String)"Sybase", (String)dataSource.getDatabaseTypeName())) {
            lnk = linkService.getOrCreate("Sybase DataSource Setup", "https://access.redhat.com/documentation/en-US/JBoss_Enterprise_Application_Platform/6.4/html/Administration_and_Configuration_Guide/sect-Example_Datasources.html#Example_Sybase_Datasource");
            linkable.addLink(lnk);
        }
        LinkModel eap6Link = linkService.getOrCreate("DataSource Documentation", "https://access.redhat.com/documentation/en-US/JBoss_Enterprise_Application_Platform/6.4/html/Administration_and_Configuration_Guide/chap-Datasource_Management.html");
        linkable.addLink(eap6Link);
    }

    public String toStringPerform() {
        return "Linking to Server Documentation";
    }
}

