/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.jboss;

import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverEjbConfigurationXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.JmsDestinationService;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResolveJBossEjbXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveJBossEjbXmlRuleProvider.class.getSimpleName());

    public ResolveJBossEjbXmlRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ResolveJBossEjbXmlRuleProvider.class).setPhase(InitialAnalysisPhase.class).addExecuteAfter(DiscoverEjbConfigurationXmlRuleProvider.class));
    }

    public String toStringPerform() {
        return "Discover JBoss EJB XML Files";
    }

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"ejb-jar").withProperty("fileName", (Object)"jboss-ejb3.xml");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        JNDIResourceModel resource;
        String jndiLocation;
        String lookupLocation;
        String resourceRefName;
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        Document doc = xmlFileService.loadDocumentQuiet(context, payload);
        if (JOOX.$((Document)doc).find("enterprise-beans").isEmpty()) {
            LOG.warning("Expected enterprise-beans tag. Ignoring: " + payload.getFileName());
            return;
        }
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        JmsDestinationService jmsDestinationService = new JmsDestinationService(event.getGraphContext());
        GraphService mdbService = new GraphService(event.getGraphContext(), EjbMessageDrivenModel.class);
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        classificationService.attachClassification(context, (FileModel)payload, "JBoss Legacy EJB XML", "JBoss Enterprise Java Bean XML Descriptor prior to EAP 6.");
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        technologyTagService.addTagToFileModel((FileModel)payload, "JBoss EJB XML", TechnologyTagLevel.IMPORTANT);
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(event.getGraphContext());
        vendorSpecificationService.associateAsVendorExtension((FileModel)payload, "ejb-jar.xml");
        for (Element resourceRef : JOOX.$((Document)doc).find("enterprise-beans").find("resource-ref").get()) {
            resourceRefName = JOOX.$((Element)resourceRef).child("res-ref-name").text();
            lookupLocation = JOOX.$((Element)resourceRef).child("lookup-name").text();
            jndiLocation = JOOX.$((Element)resourceRef).child("jndi-name").text();
            if (StringUtils.isBlank((String)jndiLocation)) {
                jndiLocation = lookupLocation;
            }
            if (!StringUtils.isNotBlank((String)jndiLocation) || !StringUtils.isNotBlank((String)resourceRefName)) continue;
            resource = jndiResourceService.createUnique(jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceRefName);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceRefName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("enterprise-beans").find("resource-env-ref").get()) {
            resourceRefName = JOOX.$((Element)resourceRef).child("resource-env-ref-name").text();
            lookupLocation = JOOX.$((Element)resourceRef).child("lookup-name").text();
            jndiLocation = JOOX.$((Element)resourceRef).child("jndi-name").text();
            if (StringUtils.isBlank((String)jndiLocation)) {
                jndiLocation = lookupLocation;
            }
            if (!StringUtils.isNotBlank((String)jndiLocation) || !StringUtils.isNotBlank((String)resourceRefName)) continue;
            resource = jndiResourceService.createUnique(jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceRefName);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceRefName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
        for (Element messageDrivenRef : JOOX.$((Document)doc).find("enterprise-beans").find("message-driven").get()) {
            String ejbName = JOOX.$((Element)messageDrivenRef).child("ejb-name").text();
            String destination = null;
            for (Element activationConfigProperty : JOOX.$((Element)messageDrivenRef).find("activation-config-property")) {
                String name = JOOX.$((Element)activationConfigProperty).child("activation-config-property-name").text();
                String value = JOOX.$((Element)activationConfigProperty).child("activation-config-property-value").text();
                if (!StringUtils.equals((String)"destination", (String)name)) continue;
                destination = value;
            }
            if (!StringUtils.isNotBlank((String)ejbName)) continue;
            for (EjbMessageDrivenModel mdb : mdbService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                if (!StringUtils.isNotBlank(destination)) continue;
                JmsDestinationModel jndiRef = jmsDestinationService.createUnique(destination);
                mdb.setDestination(jndiRef);
            }
        }
    }
}

