/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.util.IOCallable;
import com.thinkaurelius.titan.diskstorage.util.MetricInstrumentedStore;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.UncheckedCallable;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class MetricInstrumentedIterator
implements KeyIterator {
    private final KeyIterator iterator;
    private final String p;
    private static final String M_HAS_NEXT = "hasNext";
    private static final String M_NEXT = "next";
    private static final String M_CLOSE = "close";

    public static MetricInstrumentedIterator of(KeyIterator keyIterator, String ... prefix) {
        if (keyIterator == null) {
            return null;
        }
        Preconditions.checkNotNull((Object)prefix);
        return new MetricInstrumentedIterator(keyIterator, StringUtils.join((Object[])prefix, (String)"."));
    }

    private MetricInstrumentedIterator(KeyIterator i, String p) {
        this.iterator = i;
        this.p = p;
    }

    @Override
    public boolean hasNext() {
        return MetricInstrumentedStore.runWithMetrics(this.p, null, M_HAS_NEXT, new UncheckedCallable<Boolean>(){

            @Override
            public Boolean call() {
                return MetricInstrumentedIterator.this.iterator.hasNext();
            }
        });
    }

    @Override
    public StaticBuffer next() {
        return MetricInstrumentedStore.runWithMetrics(this.p, null, M_NEXT, new UncheckedCallable<StaticBuffer>(){

            @Override
            public StaticBuffer call() {
                return (StaticBuffer)MetricInstrumentedIterator.this.iterator.next();
            }
        });
    }

    @Override
    public void close() throws IOException {
        MetricInstrumentedStore.runWithMetrics(this.p, null, M_CLOSE, new IOCallable<Void>(){

            @Override
            public Void call() throws IOException {
                MetricInstrumentedIterator.this.iterator.close();
                return null;
            }
        });
    }

    @Override
    public RecordIterator<Entry> getEntries() {
        return this.iterator.getEntries();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

