/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.apache.lucene.util.Version;
import org.apache.maven.index.creator.JarFileContentsIndexCreator;

public final class NexusAnalyzer
extends Analyzer {
    public NexusAnalyzer() {
        super(PER_FIELD_REUSE_STRATEGY);
    }

    protected Tokenizer getTokenizer(String fieldName, Reader reader) {
        if (JarFileContentsIndexCreator.FLD_CLASSNAMES_KW.getKey().equals(fieldName)) {
            return new DeprecatedClassnamesTokenizer(reader);
        }
        return new LetterOrDigitTokenizer(reader);
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        return new Analyzer.TokenStreamComponents(this.getTokenizer(fieldName, reader));
    }

    public static class LetterOrDigitTokenizer
    extends CharTokenizer {
        public LetterOrDigitTokenizer(Reader in) {
            super(Version.LUCENE_46, in);
        }

        protected boolean isTokenChar(int c) {
            return Character.isLetterOrDigit(c);
        }

        protected int normalize(int c) {
            return Character.toLowerCase(c);
        }
    }

    @Deprecated
    public static class DeprecatedClassnamesTokenizer
    extends CharTokenizer {
        public DeprecatedClassnamesTokenizer(Reader in) {
            super(Version.LUCENE_46, in);
        }

        protected boolean isTokenChar(int i) {
            return i != 10;
        }

        protected int normalize(int c) {
            return Character.toLowerCase(c);
        }
    }

    public static class NoopTokenizer
    extends CharTokenizer {
        public NoopTokenizer(Reader in) {
            super(Version.LUCENE_46, in);
        }

        protected boolean isTokenChar(int i) {
            return true;
        }
    }
}

