/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.export;

import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.ProjectService;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.InlineHintService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ExportCSVFileRuleProvider
extends AbstractRuleProvider {
    public static final int COMMIT_INTERVAL = 750;
    public static final int LOG_INTERVAL = 250;
    private static Logger LOG = Logging.get(ExportCSVFileRuleProvider.class);
    Map<String, CSVWriter> projectToFile;

    public ExportCSVFileRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ExportCSVFileRuleProvider.class).setPhase(ReportGenerationPhase.class).setHaltOnException(true));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(WindupConfigurationModel.class).withProperty("csv", (Object)true)).perform((Operation)Iteration.over((String)"default").perform((Operation)new ExportCSVReportOperation()).endIteration());
    }

    private final class ExportCSVReportOperation
    extends AbstractIterationOperation<WindupConfigurationModel> {
        private ExportCSVReportOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(GraphRewrite event, EvaluationContext context, WindupConfigurationModel config) {
            ExportCSVFileRuleProvider.this.projectToFile = new HashMap<String, CSVWriter>();
            InlineHintService hintService = new InlineHintService(event.getGraphContext());
            String outputFolderPath = config.getOutputPath().getFilePath() + File.separator;
            ClassificationService classificationService = new ClassificationService(event.getGraphContext());
            ProjectService projectService = new ProjectService(event.getGraphContext());
            Iterable hints = hintService.findAll();
            Iterable projects = projectService.findAll();
            Iterable classifications = classificationService.findAll();
            try {
                for (InlineHintModel hint : hints) {
                    ProjectModel parentRootProjectModel = hint.getFile().getProjectModel().getRootProjectModel();
                    String links = this.buildLinkString(hint.getLinks());
                    String ruleId = hint.getRuleID() != null ? hint.getRuleID() : "";
                    String title = hint.getTitle() != null ? hint.getTitle() : "";
                    String description = hint.getDescription() != null ? hint.getDescription() : "";
                    String projectNameString = "";
                    String fileName = "";
                    String filePath = "";
                    if (hint.getFile() != null) {
                        if (hint.getFile().getProjectModel() != null) {
                            projectNameString = hint.getFile().getProjectModel().getName();
                        }
                        fileName = hint.getFile().getFileName();
                        filePath = hint.getFile().getFilePath();
                    }
                    String[] strings = new String[]{ruleId, "hint", title, description, links, projectNameString, fileName, filePath, String.valueOf(hint.getLineNumber()), String.valueOf(hint.getEffort())};
                    this.writeCsvRecordForProject(outputFolderPath, parentRootProjectModel, strings);
                }
                for (ClassificationModel classification : classifications) {
                    for (FileModel fileModel : classification.getFileModels()) {
                        ProjectModel parentRootProjectModel = fileModel.getProjectModel().getRootProjectModel();
                        String links = this.buildLinkString(classification.getLinks());
                        String ruleId = classification.getRuleID() != null ? classification.getRuleID() : "";
                        String classifText = classification.getClassification() != null ? classification.getClassification() : "";
                        String description = classification.getDescription() != null ? classification.getDescription() : "";
                        String projectNameString = "";
                        String fileName = "";
                        String filePath = "";
                        if (fileModel.getProjectModel() != null) {
                            projectNameString = fileModel.getProjectModel().getName();
                        }
                        fileName = fileModel.getFileName();
                        filePath = fileModel.getFilePath();
                        String[] strings = new String[]{ruleId, "classification", classifText, description, links, projectNameString, fileName, filePath, "N/A", String.valueOf(classification.getEffort())};
                        this.writeCsvRecordForProject(outputFolderPath, parentRootProjectModel, strings);
                    }
                }
            }
            catch (Throwable throwable) {
                for (CSVWriter csvWriter : ExportCSVFileRuleProvider.this.projectToFile.values()) {
                    try {
                        csvWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            for (CSVWriter csvWriter : ExportCSVFileRuleProvider.this.projectToFile.values()) {
                try {
                    csvWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private String buildLinkString(Iterable<LinkModel> links) {
            StringBuilder linksString = new StringBuilder();
            for (LinkModel linkModel : links) {
                linksString.append("[");
                linksString.append(linkModel.getLink() + ",");
                linksString.append(linkModel.getDescription());
                linksString.append("]");
            }
            linksString.toString();
            return linksString.toString();
        }

        private void writeCsvRecordForProject(String outputFolderPath, ProjectModel projectModel, String[] line) {
            if (!ExportCSVFileRuleProvider.this.projectToFile.containsKey(projectModel.getName())) {
                CSVWriter writer = this.initCSVWriter(outputFolderPath + PathUtil.cleanFileName((String)projectModel.getName()) + ".csv");
                ExportCSVFileRuleProvider.this.projectToFile.put(projectModel.getName(), writer);
            }
            ExportCSVFileRuleProvider.this.projectToFile.get(projectModel.getName()).writeNext(line);
        }

        private CSVWriter initCSVWriter(String path) {
            try {
                CSVWriter writer = new CSVWriter((Writer)new FileWriter(path), ',');
                String[] headerLine = new String[]{"Rule Id", "Problem type", "Title", "Description", "Links", "Application", "File Name", "File Path", "Line", "Story points"};
                writer.writeNext(headerLine);
                return writer;
            }
            catch (IOException e) {
                System.err.println("Windup was not able to create a CSV file " + path + ". CSV Export will not be generated.");
                throw new WindupException("Unable to create file " + path, (Throwable)e);
            }
        }
    }
}

