/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcServerAuth;

public final class OncRpcServerAuthUnix
extends OncRpcServerAuth {
    public int stamp;
    public String machinename;
    public int uid;
    public int gid;
    public int[] gids;
    private byte[] shorthandVerf;

    public OncRpcServerAuthUnix(XdrDecodingStream xdr) throws OncRpcException, IOException {
        this.xdrDecodeCredVerf(xdr);
    }

    public final int getAuthenticationType() {
        return 1;
    }

    public final void setShorthandVerifier(byte[] shorthandVerf) {
        this.shorthandVerf = shorthandVerf;
    }

    public final byte[] getShorthandVerifier() {
        return this.shorthandVerf;
    }

    public final void xdrDecodeCredVerf(XdrDecodingStream xdr) throws OncRpcException, IOException {
        this.shorthandVerf = null;
        int realLen = xdr.xdrDecodeInt();
        this.stamp = xdr.xdrDecodeInt();
        this.machinename = xdr.xdrDecodeString();
        this.uid = xdr.xdrDecodeInt();
        this.gid = xdr.xdrDecodeInt();
        this.gids = xdr.xdrDecodeIntVector();
        int len = 4 + (this.machinename.length() + 7 & 0xFFFFFFFC) + 4 + 4 + this.gids.length * 4 + 4;
        if (realLen != len) {
            if (realLen < len) {
                throw new OncRpcException(43);
            }
            throw new OncRpcException(7);
        }
        if (xdr.xdrDecodeInt() != 0 || xdr.xdrDecodeInt() != 0) {
            throw new OncRpcAuthenticationException(3);
        }
    }

    public final void xdrEncodeVerf(XdrEncodingStream xdr) throws OncRpcException, IOException {
        if (this.shorthandVerf != null) {
            xdr.xdrEncodeInt(2);
            xdr.xdrEncodeDynamicOpaque(this.shorthandVerf);
        } else {
            xdr.xdrEncodeInt(0);
            xdr.xdrEncodeInt(0);
        }
    }
}

