/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecurityPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;

public abstract class PolicyConfigurationFactory {
    private static final String FACTORY_PROP = "javax.security.jacc.PolicyConfigurationFactory.provider";
    private static final String DEFAULT_FACTORY_NAME = "org.jboss.security.jacc.JBossPolicyConfigurationFactory";
    private static PolicyConfigurationFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicyConfigurationFactory getPolicyConfigurationFactory() throws ClassNotFoundException, PolicyContextException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        Class<PolicyConfigurationFactory> clazz = PolicyConfigurationFactory.class;
        synchronized (PolicyConfigurationFactory.class) {
            if (factory == null) {
                String factoryName = null;
                Class clazz2 = null;
                try {
                    LoadAction action = new LoadAction();
                    try {
                        clazz2 = (Class)AccessController.doPrivileged(action);
                        factoryName = action.getName();
                    }
                    catch (PrivilegedActionException ex) {
                        factoryName = action.getName();
                        Exception e = ex.getException();
                        if (e instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)e;
                        }
                        throw new PolicyContextException("Failure during load of class: " + factoryName, e);
                    }
                    factory = (PolicyConfigurationFactory)clazz2.newInstance();
                }
                catch (ClassNotFoundException e) {
                    String msg = "Failed to find PolicyConfigurationFactory : " + factoryName;
                    throw new ClassNotFoundException(msg, e);
                }
                catch (IllegalAccessException e) {
                    String msg = "Unable to access class : " + factoryName;
                    throw new PolicyContextException(msg, e);
                }
                catch (InstantiationException e) {
                    String msg = "Failed to create instance of: " + factoryName;
                    throw new PolicyContextException(msg, e);
                }
                catch (ClassCastException e) {
                    StringBuffer msg = new StringBuffer(String.valueOf(factoryName) + " Is not a PolicyConfigurationFactory, ");
                    msg.append("PCF.class.CL: " + PolicyConfigurationFactory.class.getClassLoader());
                    msg.append("\nPCF.class.CS: " + PolicyConfigurationFactory.class.getProtectionDomain().getCodeSource());
                    msg.append("\nPCF.class.hash: " + System.identityHashCode(PolicyConfigurationFactory.class));
                    msg.append("\nclazz.CL: " + clazz2.getClassLoader());
                    msg.append("\nclazz.CS: " + clazz2.getProtectionDomain().getCodeSource());
                    msg.append("\nclazz.super.CL: " + clazz2.getSuperclass().getClassLoader());
                    msg.append("\nclazz.super.CS: " + clazz2.getSuperclass().getProtectionDomain().getCodeSource());
                    msg.append("\nclazz.super.hash: " + System.identityHashCode(clazz2.getSuperclass()));
                    ClassCastException cce = new ClassCastException(msg.toString());
                    cce.initCause(e);
                    throw cce;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return factory;
        }
    }

    public abstract PolicyConfiguration getPolicyConfiguration(String var1, boolean var2) throws PolicyContextException;

    public abstract boolean inService(String var1) throws PolicyContextException;

    private static class LoadAction
    implements PrivilegedExceptionAction<Class<?>> {
        private String name;

        private LoadAction() {
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> run() throws Exception {
            this.name = System.getProperty(PolicyConfigurationFactory.FACTORY_PROP);
            if (this.name == null) {
                this.name = PolicyConfigurationFactory.DEFAULT_FACTORY_NAME;
            }
            ClassLoader[] cls = new ClassLoader[]{PolicyConfigurationFactory.class.getClassLoader(), Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()};
            ClassNotFoundException e = null;
            ClassLoader[] classLoaderArray = cls;
            int n = cls.length;
            int n2 = 0;
            while (n2 < n) {
                ClassLoader cl = classLoaderArray[n2];
                if (cl != null) {
                    try {
                        return cl.loadClass(this.name);
                    }
                    catch (ClassNotFoundException ce) {
                        e = ce;
                    }
                }
                ++n2;
            }
            throw e != null ? e : new ClassNotFoundException(this.name);
        }
    }
}

