/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.pools;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.pools.PooledBuffer;
import org.xadisk.filesystem.pools.ResourcePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferPool
implements ResourcePool<PooledBuffer> {
    private final int directBufferMaxPoolSize;
    private final int nonDirectBufferMaxPoolSize;
    private final int bufferSize;
    private final AtomicInteger currentDirectPoolSize;
    private final AtomicInteger currentNonDirectPoolSize;
    private final ConcurrentLinkedQueue<PooledBuffer> directFreeBuffers;
    private final ConcurrentLinkedQueue<PooledBuffer> nonDirectFreeBuffers;
    private final int directBufferIdleTime;
    private final int nonDirectBufferIdleTime;
    private final NativeXAFileSystem xaFileSystem;

    public BufferPool(int directBufferPoolSize, int nonDirectBufferPoolSize, int bufferSize, int directBufferIdleTime, int nonDirectBufferIdleTime, NativeXAFileSystem xaFileSystem) {
        this.xaFileSystem = xaFileSystem;
        this.directBufferMaxPoolSize = directBufferPoolSize;
        this.nonDirectBufferMaxPoolSize = nonDirectBufferPoolSize;
        this.bufferSize = bufferSize;
        this.directBufferIdleTime = directBufferIdleTime;
        this.nonDirectBufferIdleTime = nonDirectBufferIdleTime;
        this.directFreeBuffers = new ConcurrentLinkedQueue();
        this.nonDirectFreeBuffers = new ConcurrentLinkedQueue();
        this.currentDirectPoolSize = new AtomicInteger(0);
        this.currentNonDirectPoolSize = new AtomicInteger(0);
    }

    @Override
    public PooledBuffer checkOut() {
        PooledBuffer temp = this.lookIntoCurrentPool(true);
        if (temp != null) {
            return temp;
        }
        temp = this.lookIntoCurrentPool(false);
        if (temp != null) {
            return temp;
        }
        temp = this.allocateNewInCurrentPool(true);
        if (temp != null) {
            return temp;
        }
        temp = this.allocateNewInCurrentPool(false);
        if (temp != null) {
            return null;
        }
        return null;
    }

    private PooledBuffer lookIntoCurrentPool(boolean inDirectBufferPool) {
        ConcurrentLinkedQueue<PooledBuffer> buffers = inDirectBufferPool ? this.directFreeBuffers : this.nonDirectFreeBuffers;
        PooledBuffer freeBuffer = buffers.poll();
        if (freeBuffer != null) {
            freeBuffer.invalidateByteBufferFromCache();
        }
        return freeBuffer;
    }

    private PooledBuffer allocateNewInCurrentPool(boolean inDirectBufferPool) {
        int temp;
        int maxPoolSize;
        AtomicInteger currentPoolSize;
        PooledBuffer newBuffer = null;
        if (inDirectBufferPool) {
            currentPoolSize = this.currentDirectPoolSize;
            maxPoolSize = this.directBufferMaxPoolSize;
        } else {
            currentPoolSize = this.currentNonDirectPoolSize;
            maxPoolSize = this.nonDirectBufferMaxPoolSize;
        }
        do {
            if ((temp = currentPoolSize.get()) < maxPoolSize) continue;
            return null;
        } while (!currentPoolSize.compareAndSet(temp, temp + 1));
        newBuffer = new PooledBuffer(this.bufferSize, inDirectBufferPool, this.xaFileSystem);
        return newBuffer;
    }

    @Override
    public void checkIn(PooledBuffer buffer) {
        buffer.markFree();
        if (buffer.isDirect) {
            this.directFreeBuffers.offer(buffer);
        } else {
            this.nonDirectFreeBuffers.offer(buffer);
        }
        buffer.flushByteBufferChanges();
    }

    @Override
    public void freeIdleMembers() {
        this.freeIdleMembers(true);
        this.freeIdleMembers(false);
    }

    private void freeIdleMembers(boolean inDirectBufferPool) {
        PooledBuffer buffer;
        ConcurrentLinkedQueue<PooledBuffer> buffers;
        int bufferIdleTime;
        AtomicInteger currentPoolSize;
        if (inDirectBufferPool) {
            currentPoolSize = this.currentDirectPoolSize;
            bufferIdleTime = this.directBufferIdleTime;
            buffers = this.directFreeBuffers;
        } else {
            currentPoolSize = this.currentNonDirectPoolSize;
            bufferIdleTime = this.nonDirectBufferIdleTime;
            buffers = this.nonDirectFreeBuffers;
        }
        long now = System.currentTimeMillis() / 1000L;
        while ((buffer = buffers.peek()) != null && now - buffer.getLastFreed() > (long)bufferIdleTime) {
            if (!buffers.remove(buffer)) continue;
            currentPoolSize.decrementAndGet();
        }
    }
}

