/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.VerifyArgument;
import com.strobel.reflection.Helper;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.TypeVisitor;
import com.strobel.reflection.Types;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.lang.model.type.TypeKind;

final class CompoundType<T>
extends Type<T> {
    private final TypeList _interfaces;
    private final Type<T> _baseType;

    CompoundType(TypeList interfaces, Type<T> baseType) {
        this._baseType = (Type)VerifyArgument.notNull(baseType, (String)"baseType");
        Type[] sortedInterfaces = (Type[])((TypeList)((Object)VerifyArgument.notNull((Object)((Object)interfaces), (String)"interfaces"))).toArray();
        Arrays.sort(sortedInterfaces, new Comparator<Type>(){

            @Override
            public int compare(Type o1, Type o2) {
                return Integer.compare(Helper.rank(o1), Helper.rank(o2));
            }
        });
        this._interfaces = interfaces;
    }

    @Override
    public <P, R> R accept(TypeVisitor<P, R> visitor, P parameter) {
        return visitor.visitTypeParameter(this, parameter);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.TYPEVAR;
    }

    @Override
    public Type<? super T> getBaseType() {
        return this._baseType;
    }

    @Override
    public TypeList getInterfaces() {
        return this._interfaces;
    }

    @Override
    public Class<T> getErasedClass() {
        return this._baseType.getErasedClass();
    }

    @Override
    public Type getDeclaringType() {
        return null;
    }

    @Override
    public int getModifiers() {
        return 1025;
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }

    @Override
    public boolean isCompoundType() {
        return true;
    }

    @Override
    public TypeList getExplicitInterfaces() {
        return this._interfaces;
    }

    @Override
    public boolean isGenericParameter() {
        return false;
    }

    @Override
    public Type<?> getExtendsBound() {
        return this._baseType;
    }

    @Override
    public Type<?> getSuperBound() {
        return super.getSuperBound();
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        Type<T> baseType = this._baseType;
        TypeList interfaces = this._interfaces;
        StringBuilder s = sb;
        if (baseType != Types.Object) {
            s = baseType.appendBriefDescription(s);
            if (!interfaces.isEmpty()) {
                s.append(" & ");
            }
        }
        int n = interfaces.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                s.append(" & ");
            }
            s = ((Type)interfaces.get(i)).appendBriefDescription(s);
        }
        return s;
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        Type<T> baseType = this._baseType;
        TypeList interfaces = this._interfaces;
        StringBuilder s = sb;
        if (baseType != Types.Object) {
            s = baseType.appendSimpleDescription(s);
            if (!interfaces.isEmpty()) {
                s.append(" & ");
            }
        }
        int n = interfaces.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                s.append(" & ");
            }
            s = ((Type)interfaces.get(i)).appendSimpleDescription(s);
        }
        return s;
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        Type<T> baseType = this._baseType;
        TypeList interfaces = this._interfaces;
        StringBuilder s = sb;
        if (baseType != Types.Object) {
            s = baseType.appendErasedDescription(s);
            if (!interfaces.isEmpty()) {
                s.append(" & ");
            }
        }
        int n = interfaces.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                s.append(" & ");
            }
            s = ((Type)interfaces.get(i)).appendErasedDescription(s);
        }
        return s;
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        return this.appendBriefDescription(sb);
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        StringBuilder s = sb;
        if (this._baseType != null && this._baseType != Types.Object) {
            s = this._baseType.appendSignature(s);
        }
        if (this._interfaces.isEmpty()) {
            return s;
        }
        s.append(':');
        Iterator i$ = this._interfaces.iterator();
        while (i$.hasNext()) {
            Type interfaceType = (Type)i$.next();
            s = interfaceType.appendSignature(s);
        }
        return s;
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        return super.appendErasedSignature(sb);
    }
}

