/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import java.util.HashMap;
import java.util.Map;

enum CompilationTarget {
    JDK1_1("1.1", 45, 3),
    JDK1_2("1.2", 46, 0),
    JDK1_3("1.3", 47, 0),
    JDK1_4("1.4", 48, 0),
    JSR14("jsr14", 48, 0),
    JDK1_4_1("1.4.1", 48, 0),
    JDK1_4_2("1.4.2", 48, 0),
    JDK1_5("1.5", 49, 0),
    JDK1_6("1.6", 50, 0),
    JDK1_7("1.7", 51, 0);

    private static CompilationTarget MIN;
    private static final CompilationTarget MAX;
    private static final Map<String, CompilationTarget> tab;
    public final String name;
    public final int majorVersion;
    public final int minorVersion;
    public static final CompilationTarget DEFAULT;

    public static CompilationTarget MIN() {
        return MIN;
    }

    public static CompilationTarget MAX() {
        return MAX;
    }

    private CompilationTarget(String name, int majorVersion, int minorVersion) {
        this.name = name;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public static CompilationTarget lookup(String name) {
        return tab.get(name);
    }

    public boolean requiresIproxy() {
        return this.compareTo(JDK1_1) <= 0;
    }

    public boolean initializeFieldsBeforeSuper() {
        return this.compareTo(JDK1_4) >= 0;
    }

    public boolean obeyBinaryCompatibility() {
        return this.compareTo(JDK1_2) >= 0;
    }

    public boolean arrayBinaryCompatibility() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean interfaceFieldsBinaryCompatibility() {
        return this.compareTo(JDK1_2) > 0;
    }

    public boolean interfaceObjectOverridesBinaryCompatibility() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean usePrivateSyntheticFields() {
        return this.compareTo(JDK1_4_2) < 0;
    }

    public boolean useInnerCacheClass() {
        return this.compareTo(JDK1_4_2) >= 0;
    }

    public boolean generateCLDCStackmap() {
        return false;
    }

    public boolean generateStackMapTable() {
        return this.compareTo(JDK1_6) >= 0;
    }

    public boolean isPackageInfoSynthetic() {
        return this.compareTo(JDK1_6) >= 0;
    }

    public boolean generateEmptyAfterBig() {
        return false;
    }

    public boolean useStringBuilder() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useSyntheticFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useEnumFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useAnnotationFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useVarargsFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useBridgeFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public char syntheticNameChar() {
        return '$';
    }

    public boolean hasClassLiterals() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean hasInvokedynamic() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean hasMethodHandles() {
        return this.hasInvokedynamic();
    }

    public boolean classLiteralsNoInit() {
        return this.compareTo(JDK1_4_2) >= 0;
    }

    public boolean hasInitCause() {
        return this.compareTo(JDK1_4) >= 0;
    }

    public boolean boxWithConstructors() {
        return this.compareTo(JDK1_5) < 0;
    }

    public boolean hasIterable() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean hasEnclosingMethodAttribute() {
        return this.compareTo(JDK1_5) >= 0 || this == JSR14;
    }

    static {
        tab = new HashMap<String, CompilationTarget>();
        CompilationTarget max = null;
        for (CompilationTarget t : CompilationTarget.values()) {
            if (MIN == null) {
                MIN = t;
            }
            max = t;
            tab.put(t.name, t);
        }
        MAX = max;
        tab.put("5", JDK1_5);
        tab.put("6", JDK1_6);
        tab.put("7", JDK1_7);
        DEFAULT = JDK1_7;
    }
}

