/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.report.IgnoredFileRegexModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.PackageModel;
import org.jboss.windup.rules.apps.java.model.WindupJavaConfigurationModel;

public class WindupJavaConfigurationService
extends GraphService<WindupJavaConfigurationModel> {
    private List<String> ignoredRegexes;

    public WindupJavaConfigurationService(GraphContext context) {
        super(context, WindupJavaConfigurationModel.class);
    }

    public static synchronized WindupJavaConfigurationModel getJavaConfigurationModel(GraphContext context) {
        WindupJavaConfigurationService service = new WindupJavaConfigurationService(context);
        WindupJavaConfigurationModel config = (WindupJavaConfigurationModel)service.getUnique();
        if (config == null) {
            config = (WindupJavaConfigurationModel)service.create();
        }
        return config;
    }

    public List<String> getIgnoredFileRegexes() {
        if (this.ignoredRegexes == null) {
            this.ignoredRegexes = new ArrayList<String>();
            WindupJavaConfigurationModel cfg = WindupJavaConfigurationService.getJavaConfigurationModel(this.getGraphContext());
            for (IgnoredFileRegexModel ignored : cfg.getIgnoredFileRegexes()) {
                if (ignored.getCompilationError() != null) continue;
                this.ignoredRegexes.add(ignored.getRegex());
            }
        }
        return this.ignoredRegexes;
    }

    public boolean shouldScanFile(String path) {
        WindupJavaConfigurationModel configuration = WindupJavaConfigurationService.getJavaConfigurationModel(this.getGraphContext());
        path = FilenameUtils.separatorsToUnix((String)path);
        for (PackageModel excludePackage : configuration.getExcludeJavaPackages()) {
            String packageAsPath = excludePackage.getPackageName().replace(".", "/");
            if (!path.contains(packageAsPath)) continue;
            return false;
        }
        boolean shouldScan = true;
        for (PackageModel includePackage : configuration.getScanJavaPackages()) {
            String packageAsPath = includePackage.getPackageName().replace(".", "/");
            if (path.contains(packageAsPath)) {
                shouldScan = true;
                break;
            }
            shouldScan = false;
        }
        return shouldScan;
    }

    public boolean shouldScanPackage(String pkg) {
        if (pkg == null) {
            pkg = "";
        }
        WindupJavaConfigurationModel configuration = WindupJavaConfigurationService.getJavaConfigurationModel(this.getGraphContext());
        for (PackageModel pkgModel : configuration.getExcludeJavaPackages()) {
            String excludePkg = pkgModel.getPackageName();
            if (!pkg.startsWith(excludePkg)) continue;
            return false;
        }
        if (!configuration.getScanJavaPackages().iterator().hasNext()) {
            return true;
        }
        for (PackageModel pkgModel : configuration.getScanJavaPackages()) {
            String includePkg = pkgModel.getPackageName();
            if (!pkg.startsWith(includePkg)) continue;
            return true;
        }
        return false;
    }
}

