/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import info.aduna.iteration.LookAheadIteration;
import java.util.Arrays;
import java.util.Iterator;

public class UnionIteration<E, X extends Exception>
extends LookAheadIteration<E, X> {
    private final Iterator<? extends Iteration<? extends E, X>> argIter;
    private volatile Iteration<? extends E, X> currentIter;

    public UnionIteration(Iteration<? extends E, X> ... args) {
        this(Arrays.asList(args));
    }

    public UnionIteration(Iterable<? extends Iteration<? extends E, X>> args) {
        this.argIter = args.iterator();
        this.currentIter = new EmptyIteration<E, X>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected E getNextElement() throws X {
        if (this.currentIter.hasNext()) {
            return this.currentIter.next();
        }
        Iterations.closeCloseable(this.currentIter);
        UnionIteration unionIteration = this;
        synchronized (unionIteration) {
            if (!this.argIter.hasNext()) {
                return null;
            }
            this.currentIter = this.argIter.next();
        }
        return this.getNextElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClose() throws X {
        super.handleClose();
        UnionIteration unionIteration = this;
        synchronized (unionIteration) {
            while (this.argIter.hasNext()) {
                Iterations.closeCloseable(this.argIter.next());
            }
        }
        Iterations.closeCloseable(this.currentIter);
    }
}

