/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.graphson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ElementPropertyConfig {
    private final List<String> vertexPropertyKeys;
    private final List<String> edgePropertyKeys;
    private final ElementPropertiesRule vertexPropertiesRule;
    private final ElementPropertiesRule edgePropertiesRule;
    private final boolean normalized;
    public static final ElementPropertyConfig AllProperties = new ElementPropertyConfig(null, null, ElementPropertiesRule.INCLUDE, ElementPropertiesRule.INCLUDE, false);

    public ElementPropertyConfig(Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, ElementPropertiesRule vertexPropertiesRule, ElementPropertiesRule edgePropertiesRule) {
        this(vertexPropertyKeys, edgePropertyKeys, vertexPropertiesRule, edgePropertiesRule, false);
    }

    public ElementPropertyConfig(Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, ElementPropertiesRule vertexPropertiesRule, ElementPropertiesRule edgePropertiesRule, boolean normalized) {
        this.vertexPropertiesRule = vertexPropertiesRule;
        this.vertexPropertyKeys = ElementPropertyConfig.sortKeys(vertexPropertyKeys, normalized);
        this.edgePropertiesRule = edgePropertiesRule;
        this.edgePropertyKeys = ElementPropertyConfig.sortKeys(edgePropertyKeys, normalized);
        this.normalized = normalized;
    }

    public static ElementPropertyConfig includeProperties(Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys) {
        return new ElementPropertyConfig(vertexPropertyKeys, edgePropertyKeys, ElementPropertiesRule.INCLUDE, ElementPropertiesRule.INCLUDE);
    }

    public static ElementPropertyConfig includeProperties(Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, boolean normalized) {
        return new ElementPropertyConfig(vertexPropertyKeys, edgePropertyKeys, ElementPropertiesRule.INCLUDE, ElementPropertiesRule.INCLUDE, normalized);
    }

    public static ElementPropertyConfig excludeProperties(Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys) {
        return new ElementPropertyConfig(vertexPropertyKeys, edgePropertyKeys, ElementPropertiesRule.EXCLUDE, ElementPropertiesRule.EXCLUDE);
    }

    public static ElementPropertyConfig excludeProperties(Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, boolean normalized) {
        return new ElementPropertyConfig(vertexPropertyKeys, edgePropertyKeys, ElementPropertiesRule.EXCLUDE, ElementPropertiesRule.EXCLUDE, normalized);
    }

    public List<String> getVertexPropertyKeys() {
        return this.vertexPropertyKeys;
    }

    public List<String> getEdgePropertyKeys() {
        return this.edgePropertyKeys;
    }

    public ElementPropertiesRule getVertexPropertiesRule() {
        return this.vertexPropertiesRule;
    }

    public ElementPropertiesRule getEdgePropertiesRule() {
        return this.edgePropertiesRule;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    private static List<String> sortKeys(Set<String> keys, boolean normalized) {
        ArrayList<String> propertyKeyList;
        if (keys != null) {
            if (normalized) {
                ArrayList<String> sorted = new ArrayList<String>(keys);
                Collections.sort(sorted);
                propertyKeyList = sorted;
            } else {
                propertyKeyList = new ArrayList<String>(keys);
            }
        } else {
            propertyKeyList = null;
        }
        return propertyKeyList;
    }

    public static enum ElementPropertiesRule {
        INCLUDE,
        EXCLUDE;

    }
}

