/*
 * Decompiled with CFR 0.152.
 */
package com.github.rwitzel.streamflyer.regex.addons.tokens;

import com.github.rwitzel.streamflyer.internal.thirdparty.ZzzValidate;
import com.github.rwitzel.streamflyer.regex.MatchProcessor;
import com.github.rwitzel.streamflyer.regex.MatchProcessorResult;
import com.github.rwitzel.streamflyer.regex.addons.tokens.MatchResultWithOffset;
import com.github.rwitzel.streamflyer.regex.addons.tokens.Token;
import com.github.rwitzel.streamflyer.regex.addons.tokens.TokensMatcher;
import java.util.List;
import java.util.regex.MatchResult;

public class TokenProcessor
implements MatchProcessor {
    private List<Token> tokens;

    public TokenProcessor(List<Token> tokens) {
        ZzzValidate.isNotEmpty(tokens, "tokens");
        this.tokens = tokens;
    }

    @Override
    public MatchProcessorResult process(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, MatchResult matchResult) {
        int groupOffset = 1;
        for (Token token : this.tokens) {
            int groupsInToken = token.getCapturingGroupCount();
            String matchedGroup = matchResult.group(groupOffset);
            if (matchedGroup != null) {
                return this.processToken(token, characterBuffer, firstModifiableCharacterInBuffer, new MatchResultWithOffset(matchResult, groupOffset));
            }
            groupOffset += groupsInToken + 1;
        }
        throw new RuntimeException("never to happen if used with " + TokensMatcher.class);
    }

    protected MatchProcessorResult processToken(Token token, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, MatchResult matchResult) {
        return token.getMatchProcessor().process(characterBuffer, firstModifiableCharacterInBuffer, matchResult);
    }
}

