/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.limited.iterator;

import info.aduna.iteration.IntersectIteration;
import info.aduna.iteration.Iteration;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.limited.iterator.LimitedSizeIteratorUtil;

public class LimitedSizeIntersectIteration
extends IntersectIteration<BindingSet, QueryEvaluationException> {
    private final AtomicLong used;
    private final long maxSize;

    public LimitedSizeIntersectIteration(Iteration<? extends BindingSet, ? extends QueryEvaluationException> arg1, Iteration<? extends BindingSet, ? extends QueryEvaluationException> arg2, AtomicLong used, long maxSize) {
        this(arg1, arg2, false, used, maxSize);
    }

    public LimitedSizeIntersectIteration(Iteration<? extends BindingSet, ? extends QueryEvaluationException> arg1, Iteration<? extends BindingSet, ? extends QueryEvaluationException> arg2, boolean distinct, AtomicLong used, long maxSize) {
        super(arg1, arg2, distinct);
        this.used = used;
        this.maxSize = maxSize;
    }

    public Set<BindingSet> addSecondSet(Iteration<? extends BindingSet, ? extends QueryEvaluationException> arg2, Set<BindingSet> set) throws QueryEvaluationException {
        LimitedSizeIteratorUtil.addAll(arg2, set, this.used, this.maxSize);
        return set;
    }

    protected void handleClose() throws QueryEvaluationException {
        long size = this.clearIncludeSet();
        this.used.addAndGet(-size);
        super.handleClose();
    }
}

