/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.profiles;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.jboss.tattletale.profiles.AbstractProfile;
import org.jboss.tattletale.profiles.ExtendedProfile;
import org.jboss.tattletale.profiles.Profile;
import org.jboss.tattletale.profiles.ProfileArchive;

public class JBossAS7Profile
extends AbstractProfile
implements ExtendedProfile {
    private static final String CLASS_SET = "jbossas7.clz.gz";
    private static final String PROFILE_NAME = "JBoss AS 7";
    private static final String PROFILE_CODE = "as7";
    private static final String PROFILE_LOCATION = "jboss-modules.jar";
    private static final int ARCHIVE_TYPE = 1;
    private static final int CLASSFILE_VERSION = 50;

    public JBossAS7Profile() {
        super(1, PROFILE_NAME, 50, PROFILE_LOCATION);
        this.loadProfile(CLASS_SET);
    }

    public String getModuleIdentifier(String clz) {
        for (Profile p : this.subProfiles) {
            if (!p.doesProvide(clz)) continue;
            return p.getModuleIdentifier();
        }
        return null;
    }

    public boolean doesProvide(String clz) {
        return super.doesProvide(clz);
    }

    public String getName() {
        return PROFILE_NAME;
    }

    public String getProfileCode() {
        return PROFILE_CODE;
    }

    public String getProfileName() {
        return PROFILE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProfile(String classSet) {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(classSet);
            GZIPInputStream gis = new GZIPInputStream(inputStream);
            InputStreamReader isr = new InputStreamReader(gis);
            BufferedReader br = new BufferedReader(isr);
            HashMap<String, ProfileArchive> profileMapping = new HashMap<String, ProfileArchive>();
            String s = br.readLine();
            while (s != null) {
                ProfileArchive profileArchive;
                StringTokenizer tokenizer = new StringTokenizer(s, ",");
                String className = tokenizer.nextToken();
                String archiveName = tokenizer.nextToken();
                String moduleIdentifier = "";
                if (tokenizer.hasMoreTokens()) {
                    moduleIdentifier = tokenizer.nextToken();
                }
                if ((profileArchive = (ProfileArchive)profileMapping.get(archiveName)) == null) {
                    profileArchive = new ProfileArchive(archiveName, moduleIdentifier);
                    profileMapping.put(archiveName, profileArchive);
                }
                profileArchive.addClass(className);
                s = br.readLine();
            }
            this.subProfiles.addAll(profileMapping.values());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

