/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.AbstractBeanInstance;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.EmptyInjectionPoint;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.reflection.Reflections;

@SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="bean field is loaded lazily")
public class ContextBeanInstance<T>
extends AbstractBeanInstance
implements Serializable {
    private static final long serialVersionUID = -8144230657830556503L;
    private transient Bean<T> bean;
    private final BeanIdentifier id;
    private final String contextId;
    private final Class<?> instanceType;
    private static final ThreadLocal<WeldCreationalContext<?>> currentCreationalContext = new ThreadLocal();

    public ContextBeanInstance(Bean<T> bean, BeanIdentifier id, String contextId) {
        this.bean = bean;
        this.id = id;
        this.contextId = contextId;
        this.instanceType = this.computeInstanceType(bean);
        BeanLogger.LOG.createdContextInstance(bean, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getInstance() {
        Context context;
        Object existingInstance;
        Container container = Container.instance(this.contextId);
        if (this.bean == null) {
            this.bean = (Bean)((ContextualStore)container.services().get(ContextualStore.class)).getContextual(this.id);
        }
        if ((existingInstance = (context = container.deploymentManager().getContext(this.bean.getScope())).get(this.bean)) != null) {
            return (T)existingInstance;
        }
        WeldCreationalContext<?> previousCreationalContext = currentCreationalContext.get();
        WeldCreationalContext<T> creationalContext = previousCreationalContext == null ? new CreationalContextImpl<T>(this.bean) : previousCreationalContext.getCreationalContext(this.bean);
        CurrentInjectionPoint currentInjectionPoint = (CurrentInjectionPoint)container.services().get(CurrentInjectionPoint.class);
        currentCreationalContext.set(creationalContext);
        try {
            currentInjectionPoint.push(EmptyInjectionPoint.INSTANCE);
            Object object = context.get(this.bean, creationalContext);
            return (T)object;
        }
        finally {
            currentInjectionPoint.pop();
            if (previousCreationalContext == null) {
                currentCreationalContext.remove();
            } else {
                currentCreationalContext.set(previousCreationalContext);
            }
        }
    }

    public Class<T> getInstanceType() {
        return (Class)Reflections.cast(this.instanceType);
    }
}

