/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.decompiler;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.PipeFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CleanFromMultipleSourceFiles
extends GraphOperation {
    public void perform(GraphRewrite event, EvaluationContext context) {
        GremlinPipeline pipeline = new GremlinPipeline((Object)event.getGraphContext().getQuery().type(JavaSourceFileModel.class).vertices());
        GraphContext gContext = event.getGraphContext();
        pipeline.groupBy(this.groupByProjectModelFunction(gContext), this.valueAsFramedVertex(gContext), this.returnVerticesToDelete(gContext)).cap();
        HashMap m = (HashMap)pipeline.next();
        for (List toBeDeleted : m.values()) {
            for (JavaSourceFileModel javaSourceFileModel : toBeDeleted) {
                gContext.getGraph().removeVertex(javaSourceFileModel.asVertex());
            }
        }
    }

    private PipeFunction groupByProjectModelFunction(final GraphContext context) {
        return new PipeFunction<Vertex, String>(){

            public String compute(Vertex vertex) {
                JavaSourceFileModel javaModel = (JavaSourceFileModel)context.getFramed().frame(vertex, JavaSourceFileModel.class);
                ProjectModel projectModel = javaModel.getProjectModel();
                String projectModelID = projectModel == null ? "" : projectModel.asVertex().getId().toString();
                String packageName = javaModel.getPackageName() == null ? "" : javaModel.getPackageName();
                return projectModelID + "_" + packageName + "_" + javaModel.getFileName();
            }
        };
    }

    private PipeFunction valueAsFramedVertex(final GraphContext context) {
        return new PipeFunction<Vertex, JavaSourceFileModel>(){

            public JavaSourceFileModel compute(Vertex vertex) {
                return (JavaSourceFileModel)context.getFramed().frame(vertex, JavaSourceFileModel.class);
            }
        };
    }

    private PipeFunction returnVerticesToDelete(GraphContext context) {
        return new PipeFunction<Collection<JavaSourceFileModel>, List<JavaSourceFileModel>>(){

            public List<JavaSourceFileModel> compute(Collection<JavaSourceFileModel> javaClassFileModels) {
                boolean uniqueClassFound = false;
                ArrayList<JavaSourceFileModel> verticesToBeDeleted = new ArrayList<JavaSourceFileModel>();
                if (javaClassFileModels.size() == 0) {
                    return null;
                }
                Iterator<JavaSourceFileModel> iterator = javaClassFileModels.iterator();
                while (iterator.hasNext()) {
                    JavaSourceFileModel javaModel = iterator.next();
                    if (javaModel.isDecompiled() != null && javaModel.isDecompiled().booleanValue() && !uniqueClassFound) {
                        uniqueClassFound = true;
                        continue;
                    }
                    if (!iterator.hasNext() && !uniqueClassFound) {
                        uniqueClassFound = true;
                        continue;
                    }
                    verticesToBeDeleted.add(javaModel);
                }
                return verticesToBeDeleted;
            }
        };
    }
}

