/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.PostMigrationRulesPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.service.EjbRemoteServiceModelService;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverRemoteEjbRuleProvider
extends IteratingRuleProvider<EjbSessionBeanModel> {
    private static final Logger LOG = Logger.getLogger(DiscoverRemoteEjbRuleProvider.class.getSimpleName());

    public DiscoverRemoteEjbRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverRemoteEjbRuleProvider.class).setPhase(PostMigrationRulesPhase.class));
    }

    public String toStringPerform() {
        return "Mark EJB Remote Class Files";
    }

    public ConditionBuilder when() {
        return Query.fromType(EjbSessionBeanModel.class);
    }

    public void perform(GraphRewrite event, EvaluationContext context, EjbSessionBeanModel payload) {
        if (payload.getEjbRemote() != null) {
            EjbRemoteServiceModelService service = new EjbRemoteServiceModelService(event.getGraphContext());
            service.getOrCreate(payload.getEjbRemote(), payload.getEjbClass());
        }
    }
}

