/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.oupls.sail;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.oupls.sail.FilteredIterator;
import com.tinkerpop.blueprints.oupls.sail.GraphSail;
import com.tinkerpop.blueprints.oupls.sail.Matcher;
import java.util.LinkedList;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class IndexingMatcher
extends Matcher {
    private final String propertyKey;
    private final GraphSail.DataStore store;

    public IndexingMatcher(boolean s, boolean p, boolean o, boolean c, GraphSail.DataStore store) {
        super(s, p, o, c);
        this.store = store;
        StringBuilder sb = new StringBuilder();
        if (c) {
            sb.append("c");
        }
        if (s) {
            sb.append("s");
        }
        if (p) {
            sb.append("p");
        }
        if (o) {
            sb.append("o");
        }
        this.propertyKey = sb.toString();
    }

    private <T> List<T> addLazy(List<T> list, T toAdd) {
        list = null == list ? new LinkedList<T>() : list;
        list.add(toAdd);
        return list;
    }

    private String appendToKey(String key, String part) {
        return null == key ? part : key + " " + part;
    }

    @Override
    public Iterable<Edge> match(Resource subject, URI predicate, Value object, Resource context, boolean includeInferred) {
        List criteria = null;
        String key = null;
        if (this.c) {
            key = null == context ? "N" : this.store.resourceToNative(context);
        } else if (null != context) {
            criteria = this.addLazy(criteria, new PartOfSpeechCriterion(PartOfSpeech.CONTEXT, this.store.resourceToNative(context)));
        }
        if (this.s) {
            key = this.appendToKey(key, this.store.resourceToNative(subject));
        } else if (null != subject) {
            criteria = this.addLazy(criteria, new PartOfSpeechCriterion(PartOfSpeech.SUBJECT, this.store.resourceToNative(subject)));
        }
        if (this.p) {
            key = this.appendToKey(key, this.store.uriToNative(predicate));
        } else if (null != predicate) {
            criteria = this.addLazy(criteria, new PartOfSpeechCriterion(PartOfSpeech.PREDICATE, this.store.uriToNative(predicate)));
        }
        if (this.o) {
            key = this.appendToKey(key, this.store.valueToNative(object));
        } else if (null != object) {
            criteria = this.addLazy(criteria, new PartOfSpeechCriterion(PartOfSpeech.OBJECT, this.store.valueToNative(object)));
        }
        if (!includeInferred) {
            criteria = this.addLazy(criteria, new Matcher.NoInferenceCriterion());
        }
        Object results = this.store.graph.getEdges(this.propertyKey, (Object)key);
        if (null != criteria) {
            FilteredIterator.CompoundCriterion c = new FilteredIterator.CompoundCriterion(criteria);
            results = new FilteredIterator(results, c);
        }
        return results;
    }

    public void indexStatement(Edge statement, Resource subject, URI predicate, Value object, String context) {
        StringBuilder sb = new StringBuilder();
        if (this.c) {
            sb.append(" ").append(context);
        }
        if (this.s) {
            sb.append(" ").append(this.store.resourceToNative(subject));
        }
        if (this.p) {
            sb.append(" ").append(this.store.uriToNative(predicate));
        }
        if (this.o) {
            sb.append(" ").append(this.store.valueToNative(object));
        }
        statement.setProperty(this.propertyKey, (Object)sb.toString().substring(1));
    }

    private class PartOfSpeechCriterion
    implements FilteredIterator.Criterion<Edge> {
        private final PartOfSpeech partOfSpeech;
        private final String value;

        public PartOfSpeechCriterion(PartOfSpeech partOfSpeech, String value) {
            this.partOfSpeech = partOfSpeech;
            this.value = value;
        }

        @Override
        public boolean fulfilledBy(Edge edge) {
            switch (this.partOfSpeech) {
                case CONTEXT: {
                    return this.value.equals(edge.getProperty("c"));
                }
                case OBJECT: {
                    return this.value.equals(IndexingMatcher.this.store.getValueOf(edge.getVertex(Direction.IN)));
                }
                case PREDICATE: {
                    return this.value.equals(edge.getProperty("p"));
                }
                case SUBJECT: {
                    return this.value.equals(IndexingMatcher.this.store.getValueOf(edge.getVertex(Direction.OUT)));
                }
            }
            throw new IllegalStateException();
        }
    }

    private static enum PartOfSpeech {
        SUBJECT,
        PREDICATE,
        OBJECT,
        CONTEXT;

    }
}

