/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.CLSReport;
import org.jboss.tattletale.reporting.Dump;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitiveDependantsReport
extends CLSReport {
    private static final String NAME = "Transitive Dependants";
    private static final String DIRECTORY = "transitivedependants";

    public TransitiveDependantsReport() {
        super(DIRECTORY, 0, NAME, DIRECTORY);
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Archive</th>" + Dump.newLine());
        bw.write("     <th>Dependants</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        TreeMap<String, SortedSet<String>> dependantsMap = new TreeMap<String, SortedSet<String>>();
        for (Archive archive : this.archives) {
            TreeSet<String> result = new TreeSet<String>();
            for (Archive a : this.archives) {
                if (a.getType() != 1) continue;
                for (String require : this.getRequires(a)) {
                    if (!archive.doesProvide(require) || this.getCLS() != null && !this.getCLS().isVisible(a, archive)) continue;
                    result.add(a.getName());
                }
            }
            dependantsMap.put(archive.getName(), result);
        }
        TreeMap<String, TreeSet<String>> transitiveDependantsMap = new TreeMap<String, TreeSet<String>>();
        for (Map.Entry entry : dependantsMap.entrySet()) {
            String archive = (String)entry.getKey();
            SortedSet value = (SortedSet)entry.getValue();
            TreeSet<String> result = new TreeSet<String>();
            if (value != null && value.size() > 0) {
                for (String aValue : value) {
                    this.resolveDependants(aValue, archive, dependantsMap, result);
                }
            }
            transitiveDependantsMap.put(archive, result);
        }
        boolean odd = true;
        for (Map.Entry entry : transitiveDependantsMap.entrySet()) {
            String archive = (String)entry.getKey();
            SortedSet value = (SortedSet)entry.getValue();
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td><a href=\"../jar/" + archive + ".html\">" + archive + "</a></td>" + Dump.newLine());
            bw.write("     <td>");
            if (value.size() == 0) {
                bw.write("&nbsp;");
            } else {
                Iterator valueIt = value.iterator();
                while (valueIt.hasNext()) {
                    String r = (String)valueIt.next();
                    if (r.endsWith(".jar")) {
                        bw.write("<a href=\"../jar/" + r + ".html\">" + r + "</a>");
                    } else {
                        bw.write("<i>" + r + "</i>");
                    }
                    if (!valueIt.hasNext()) continue;
                    bw.write(", ");
                }
            }
            bw.write("</td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("</table>" + Dump.newLine());
    }

    private Set<String> getRequires(Archive a) {
        HashSet<String> requires = new HashSet<String>();
        if (a instanceof NestableArchive) {
            NestableArchive na = (NestableArchive)a;
            List<Archive> subArchives = na.getSubArchives();
            requires.addAll(na.getRequires());
            for (Archive sa : subArchives) {
                requires.addAll(this.getRequires(sa));
            }
        } else {
            requires.addAll(a.getRequires());
        }
        return requires;
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Transitive Dependants</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    private void resolveDependants(String scanArchive, String archive, SortedMap<String, SortedSet<String>> map, SortedSet<String> result) {
        if (!archive.equals(scanArchive) && !result.contains(scanArchive)) {
            result.add(scanArchive);
            SortedSet value = (SortedSet)map.get(scanArchive);
            if (value != null) {
                for (String aValue : value) {
                    this.resolveDependants(aValue, archive, map, result);
                }
            }
        }
    }
}

