/*
 * Decompiled with CFR 0.152.
 */
package com.github.rwitzel.streamflyer.regex;

import com.github.rwitzel.streamflyer.internal.thirdparty.ZzzValidate;
import com.github.rwitzel.streamflyer.regex.AbstractMatchProcessor;
import com.github.rwitzel.streamflyer.regex.MatchProcessor;
import com.github.rwitzel.streamflyer.regex.MatchProcessorResult;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;

public class ReplacingProcessor
extends AbstractMatchProcessor
implements MatchProcessor {
    private List<Object> parts = null;
    private CharSequence replacementWithoutGroupReferences;

    public ReplacingProcessor() {
    }

    public ReplacingProcessor(String replacement) {
        ZzzValidate.notNull(replacement, "replacement must not be null");
        this.parts = this.parseReplacement(replacement);
        this.replacementWithoutGroupReferences = this.parts.size() == 1 && this.parts.get(0) instanceof CharSequence ? (CharSequence)this.parts.get(0) : null;
    }

    List<Object> parseReplacement(String replacement) {
        ArrayList<Object> compiledReplacement = new ArrayList<Object>();
        int position = 0;
        StringBuilder notGroupReference = new StringBuilder();
        while (position < replacement.length()) {
            char ch = replacement.charAt(position);
            if (ch == '$') {
                int groupNumberStartPosition;
                if (notGroupReference.length() != 0) {
                    compiledReplacement.add(notGroupReference.toString());
                    notGroupReference.setLength(0);
                }
                if ((groupNumberStartPosition = ++position) == replacement.length()) {
                    throw new IllegalArgumentException("group reference $ without number at the end of the replacement string (" + replacement + ")");
                }
                ch = replacement.charAt(position);
                while ('0' <= ch && ch <= '9' && ++position != replacement.length()) {
                    ch = replacement.charAt(position);
                }
                if (position == groupNumberStartPosition) {
                    throw new IllegalArgumentException("invalid reference to group at position " + position + " in replacement string " + replacement.substring(0, position) + "[]" + replacement.substring(position));
                }
                String groupNumberString = replacement.substring(groupNumberStartPosition, position);
                int groupNumber = Integer.parseInt(groupNumberString);
                compiledReplacement.add(groupNumber);
                continue;
            }
            if (ch == '\\') {
                ch = replacement.charAt(++position);
                notGroupReference.append(ch);
                ++position;
                continue;
            }
            notGroupReference.append(ch);
            ++position;
        }
        if (notGroupReference.length() != 0) {
            compiledReplacement.add(notGroupReference.toString());
        }
        return compiledReplacement;
    }

    @Override
    public MatchProcessorResult process(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, MatchResult matchResult) {
        int start = matchResult.start();
        int end = matchResult.end();
        if (this.replacementWithoutGroupReferences != null) {
            characterBuffer.delete(start, end);
            characterBuffer.insert(start, this.replacementWithoutGroupReferences);
            return this.createResult(matchResult, start + this.replacementWithoutGroupReferences.length(), true);
        }
        StringBuilder replacement = new StringBuilder();
        for (Object part : this.parts) {
            if (part instanceof Integer) {
                replacement.append(matchResult.group((Integer)part));
                continue;
            }
            replacement.append(part);
        }
        characterBuffer.delete(start, end);
        characterBuffer.insert(start, replacement);
        return this.createResult(matchResult, start + replacement.length(), true);
    }
}

