/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.TagUtil;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.service.ClassificationServiceCache;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ClassificationService
extends GraphService<ClassificationModel> {
    public ClassificationService(GraphContext context) {
        super(context, ClassificationModel.class);
    }

    public int getMigrationEffortPoints(FileModel fileModel) {
        GremlinPipeline classificationPipeline = new GremlinPipeline((Object)fileModel.asVertex());
        classificationPipeline.in(new String[]{"ClassificationModel:classificationModelToFileModel"});
        classificationPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"ClassificationModel");
        int classificationEffort = 0;
        for (Vertex v : classificationPipeline) {
            Integer migrationEffort = (Integer)v.getProperty("ClassificationModel:effort");
            if (migrationEffort == null) continue;
            classificationEffort += migrationEffort.intValue();
        }
        return classificationEffort;
    }

    public Iterable<ClassificationModel> getClassifications(FileModel model) {
        GremlinPipeline pipeline = new GremlinPipeline((Object)model.asVertex());
        pipeline.in(new String[]{"ClassificationModel:classificationModelToFileModel"});
        pipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"ClassificationModel");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)pipeline, ClassificationModel.class);
    }

    public Iterable<ClassificationModel> getClassificationByName(FileModel model, String classificationName) {
        GremlinPipeline pipeline = new GremlinPipeline((Object)model.asVertex());
        pipeline.in(new String[]{"ClassificationModel:classificationModelToFileModel"});
        pipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"ClassificationModel");
        pipeline.has("ClassificationModel:classification", (Object)classificationName);
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)pipeline, ClassificationModel.class);
    }

    public int getMigrationEffortPoints(ProjectModel projectModel, Set<String> includeTags, Set<String> excludeTags, boolean recursive) {
        GremlinPipeline classificationPipeline = new GremlinPipeline((Object)projectModel.asVertex());
        classificationPipeline.out(new String[]{"projectModelToFile"}).in(new String[]{"ClassificationModel:classificationModelToFileModel"});
        classificationPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"ClassificationModel");
        int classificationEffort = 0;
        for (Vertex v : classificationPipeline) {
            ClassificationModel classificationModel;
            Integer migrationEffort = (Integer)v.getProperty("ClassificationModel:effort");
            if ((!includeTags.isEmpty() || !excludeTags.isEmpty()) && !TagUtil.isTagsMatch((classificationModel = (ClassificationModel)this.frame(v)).getTags(), includeTags, excludeTags) || migrationEffort == null) continue;
            classificationEffort += migrationEffort.intValue();
        }
        if (recursive) {
            for (ProjectModel childProject : projectModel.getChildProjects()) {
                classificationEffort += this.getMigrationEffortPoints(childProject, includeTags, excludeTags, recursive);
            }
        }
        return classificationEffort;
    }

    public ClassificationModel attachClassification(Rule rule, FileModel fileModel, String classificationText, String description) {
        ClassificationModel model = (ClassificationModel)this.getUnique(this.getTypedQuery().has("ClassificationModel:classification", (Object)classificationText));
        if (model != null) {
            return this.attachClassification(model, fileModel);
        }
        model = (ClassificationModel)this.create();
        model.setClassification(classificationText);
        model.setDescription(description);
        model.setEffort(0);
        model.addFileModel(fileModel);
        model.setRuleID(rule.getId());
        return model;
    }

    public ClassificationModel attachClassification(EvaluationContext context, FileModel fileModel, String classificationText, String description) {
        Rule rule = (Rule)context.get(Rule.class);
        return this.attachClassification(rule, fileModel, classificationText, description);
    }

    private boolean isClassificationLinkedToFileModel(ClassificationModel classificationModel, FileModel fileModel) {
        return ClassificationServiceCache.isClassificationLinkedToFileModel(classificationModel, fileModel);
    }

    public ClassificationModel attachClassification(ClassificationModel classificationModel, FileModel fileModel) {
        if (!this.isClassificationLinkedToFileModel(classificationModel, fileModel)) {
            classificationModel.addFileModel(fileModel);
        }
        ClassificationServiceCache.cacheClassificationFileModel(classificationModel, fileModel, true);
        return classificationModel;
    }

    public ClassificationModel attachLink(ClassificationModel classificationModel, LinkModel linkModel) {
        for (LinkModel existing : classificationModel.getLinks()) {
            if (!StringUtils.equals((String)existing.getLink(), (String)linkModel.getLink())) continue;
            return classificationModel;
        }
        classificationModel.addLink(linkModel);
        return classificationModel;
    }
}

