/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Set;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.TagUtil;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.rules.files.model.FileReferenceModel;

public class InlineHintService
extends GraphService<InlineHintModel> {
    public InlineHintService(GraphContext context) {
        super(context, InlineHintModel.class);
    }

    public Iterable<InlineHintModel> getHintsForFileReference(FileReferenceModel reference) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)reference.asVertex());
        inlineHintPipeline.in(new String[]{"Hint:fileLocationReference"});
        inlineHintPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Hint");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)inlineHintPipeline, InlineHintModel.class);
    }

    public Iterable<InlineHintModel> getHintsForFile(FileModel file) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)file.asVertex());
        inlineHintPipeline.in(new String[]{"file"});
        inlineHintPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Hint");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)inlineHintPipeline, InlineHintModel.class);
    }

    public int getMigrationEffortPoints(FileModel fileModel) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)fileModel.asVertex());
        inlineHintPipeline.in(new String[]{"file"});
        inlineHintPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Hint");
        int hintEffort = 0;
        for (Vertex v : inlineHintPipeline) {
            hintEffort += ((Integer)v.getProperty("ClassificationModel:effort")).intValue();
        }
        return hintEffort;
    }

    public int getMigrationEffortPoints(ProjectModel projectModel, Set<String> includeTags, Set<String> excludeTags, boolean recursive) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)projectModel.asVertex());
        inlineHintPipeline.out(new String[]{"projectModelToFile"}).in(new String[]{"file"});
        inlineHintPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Hint");
        int hintEffort = 0;
        for (Vertex v : inlineHintPipeline) {
            InlineHintModel hintModel;
            if ((!includeTags.isEmpty() || !excludeTags.isEmpty()) && !TagUtil.isTagsMatch((hintModel = (InlineHintModel)this.frame(v)).getTags(), includeTags, excludeTags)) continue;
            hintEffort += ((Integer)v.getProperty("ClassificationModel:effort")).intValue();
        }
        if (recursive) {
            for (ProjectModel childProject : projectModel.getChildProjects()) {
                hintEffort += this.getMigrationEffortPoints(childProject, includeTags, excludeTags, recursive);
            }
        }
        return hintEffort;
    }
}

