/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.spi.PersistenceProvider;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.config.PersistenceProviderDeploymentHolder;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderResolverImpl;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.transaction.JtaManagerImpl;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class PersistenceProviderProcessor
implements DeploymentUnitProcessor {
    private static final String PERSISTENCE_PROVIDER_CLASSNAME = PersistenceProvider.class.getName();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            String adapterClass;
            ModuleClassLoader deploymentModuleClassLoader = module.getClassLoader();
            List providerNames = servicesAttachment.getServiceImplementations(PERSISTENCE_PROVIDER_CLASSNAME);
            ArrayList<PersistenceProvider> providerList = new ArrayList<PersistenceProvider>();
            for (String providerName : providerNames) {
                try {
                    Class<PersistenceProvider> providerClass = deploymentModuleClassLoader.loadClass(providerName).asSubclass(PersistenceProvider.class);
                    Constructor<PersistenceProvider> constructor = providerClass.getConstructor(new Class[0]);
                    PersistenceProvider provider = constructor.newInstance(new Object[0]);
                    Set<ClassLoader> deploymentClassLoaders = this.allDeploymentModuleClassLoaders(deploymentUnit);
                    JpaLogger.ROOT_LOGGER.debugf("Deployment has its own persistence provider %s associated with classloaders %s", providerClass, (Object)deploymentClassLoaders.toString());
                    PersistenceProviderResolverImpl.getInstance().addDeploymentSpecificPersistenceProvider(provider, deploymentClassLoaders);
                    providerList.add(provider);
                }
                catch (Exception e) {
                    throw JpaMessages.MESSAGES.cannotDeployApp((Throwable)e, providerName);
                }
            }
            if (providerList.size() > 0 && (adapterClass = (String)deploymentUnit.getAttachment(JpaAttachments.ADAPTOR_CLASS_NAME)) != null) {
                try {
                    PersistenceProviderAdaptor adaptor = (PersistenceProviderAdaptor)deploymentModuleClassLoader.loadClass(adapterClass).newInstance();
                    adaptor.injectJtaManager(JtaManagerImpl.getInstance());
                    deploymentUnit.putAttachment(JpaAttachments.DEPLOYED_PERSISTENCE_PROVIDER, (Object)new PersistenceProviderDeploymentHolder(providerList, adaptor));
                }
                catch (InstantiationException e) {
                    throw JpaMessages.MESSAGES.cannotCreateAdapter((Throwable)e, adapterClass);
                }
                catch (IllegalAccessException e) {
                    throw JpaMessages.MESSAGES.cannotCreateAdapter((Throwable)e, adapterClass);
                }
                catch (ClassNotFoundException e) {
                    throw JpaMessages.MESSAGES.cannotCreateAdapter((Throwable)e, adapterClass);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        DeploymentUnit toplevelDeploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit);
        Module module = (Module)toplevelDeploymentUnit.getAttachment(Attachments.MODULE);
        Set<ClassLoader> deploymentClassLoaders = this.allDeploymentModuleClassLoaders(deploymentUnit);
        PersistenceProviderResolverImpl.getInstance().clearCachedDeploymentSpecificProviders(deploymentClassLoaders);
    }

    private Set<ClassLoader> allDeploymentModuleClassLoaders(DeploymentUnit deploymentUnit) {
        DeploymentUnit topDeploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit);
        Module toplevelModule = (Module)topDeploymentUnit.getAttachment(Attachments.MODULE);
        HashSet<ClassLoader> deploymentClassLoaders = new HashSet<ClassLoader>();
        deploymentClassLoaders.add((ClassLoader)toplevelModule.getClassLoader());
        List subDeployments = topDeploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
        for (DeploymentUnit subDeploymentUnit : subDeployments) {
            Module subDeploymentModule = (Module)subDeploymentUnit.getAttachment(Attachments.MODULE);
            if (subDeploymentModule == null) continue;
            deploymentClassLoaders.add((ClassLoader)subDeploymentModule.getClassLoader());
        }
        return deploymentClassLoaders;
    }
}

