/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.command;

import javax.enterprise.inject.Vetoed;
import javax.inject.Singleton;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.command.PrerequisiteCommandsProvider;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.command.UICommandTransformer;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.wizard.UIWizard;

@Singleton
public class PrerequisiteCommandTransformer
implements UICommandTransformer {
    public UICommand transform(UIContext context, UICommand original) {
        Object result;
        if (original instanceof PrerequisiteCommandsProvider) {
            NavigationResult navigationResult = ((PrerequisiteCommandsProvider)original).getPrerequisiteCommands(context);
            if (navigationResult == null || navigationResult.getNext().length == 0) {
                result = original;
            } else {
                NavigationResultBuilder builder = NavigationResultBuilder.create((NavigationResult)navigationResult);
                builder.add(original);
                result = new DelegateWizard(original, builder.build());
            }
        } else {
            result = original;
        }
        return result;
    }

    @Vetoed
    private static class DelegateWizard
    extends AbstractUICommand
    implements UIWizard {
        private final UICommand originalCmd;
        private final NavigationResult result;

        DelegateWizard(UICommand originalCmd, NavigationResult result) {
            this.originalCmd = originalCmd;
            this.result = result;
        }

        public UICommandMetadata getMetadata(UIContext context) {
            return this.originalCmd.getMetadata(context);
        }

        public NavigationResult next(UINavigationContext context) throws Exception {
            return this.result;
        }

        public Result execute(UIExecutionContext context) throws Exception {
            return Results.success();
        }

        public void initializeUI(UIBuilder builder) throws Exception {
        }
    }
}

