/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import java.io.File;
import java.nio.file.Path;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.windup.graph.GraphApiCompositeClassLoaderProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.GraphContextImpl;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.graph.GraphTypeRegistry;

@Singleton
public class GraphContextFactoryImpl
implements GraphContextFactory {
    @Inject
    private GraphApiCompositeClassLoaderProvider graphApiCompositeClassLoaderProvider;
    @Inject
    private Furnace furnace;
    @Inject
    private GraphTypeRegistry graphTypeRegistry;
    @Inject
    private GraphTypeManager graphTypeManager;
    private GraphContext graphContext;

    public GraphContext create() {
        return new GraphContextImpl(this.furnace, this.graphTypeRegistry, this.graphTypeManager, this.graphApiCompositeClassLoaderProvider, this.getTempGraphDirectory()).create();
    }

    public GraphContext create(Path graphDir) {
        return new GraphContextImpl(this.furnace, this.graphTypeRegistry, this.graphTypeManager, this.graphApiCompositeClassLoaderProvider, graphDir).create();
    }

    public GraphContext load(Path graphDir) {
        return new GraphContextImpl(this.furnace, this.graphTypeRegistry, this.graphTypeManager, this.graphApiCompositeClassLoaderProvider, graphDir).load();
    }

    @Produces
    @ApplicationScoped
    public GraphContext produceGraphContext() {
        if (this.graphContext == null) {
            this.graphContext = this.create();
        }
        return this.graphContext;
    }

    private Path getTempGraphDirectory() {
        return new File(FileUtils.getTempDirectory(), "windupgraph_" + RandomStringUtils.randomAlphanumeric((int)6)).toPath();
    }
}

