/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Annotations;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.builder.RuleProviderBuilder;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.HandlerId;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilder;
import org.ocpsoft.rewrite.config.ConfigurationRuleParameterWhere;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParserContext {
    private List<AbstractRuleProvider> ruleProviders = new ArrayList<AbstractRuleProvider>();
    private RuleProviderBuilder builder;
    private ConfigurationRuleBuilder rule;
    private ConfigurationRuleParameterWhere where;
    private final Map<HandlerId, ElementHandler<?>> handlers = new HashMap();
    private Addon addonContainingInputXML;
    private Path xmlInputRootPath;
    private Path xmlInputPath;

    public ParserContext(Furnace furnace) {
        Imported loadedHandlers = furnace.getAddonRegistry(new AddonRepository[0]).getServices(ElementHandler.class);
        for (ElementHandler handler : loadedHandlers) {
            NamespaceElementHandler annotation = (NamespaceElementHandler)Annotations.getAnnotation(handler.getClass(), NamespaceElementHandler.class);
            if (annotation == null) continue;
            HandlerId handlerID = new HandlerId(annotation.namespace(), annotation.elementName());
            if (this.handlers.containsKey(handlerID)) {
                String className1 = Proxies.unwrapProxyClassName(this.handlers.get(handlerID).getClass());
                String className2 = Proxies.unwrapProxyClassName(handler.getClass());
                throw new WindupException("Multiple handlers registered with id: " + handlerID + " Classes are: " + className1 + " and " + className2);
            }
            this.handlers.put(handlerID, handler);
        }
    }

    public <T> T processElement(Element element) throws ConfigurationException {
        String tagName;
        String namespace = JOOX.$((Element)element).namespaceURI();
        ElementHandler<?> handler = this.handlers.get(new HandlerId(namespace, tagName = JOOX.$((Element)element).tag()));
        if (handler != null) {
            Object o = handler.processElement(this, element);
            return (T)o;
        }
        throw new ConfigurationException("No Handler registered for element named [" + tagName + "] in namespace: [" + namespace + "]");
    }

    public <T> T processDocument(URI uri) throws ConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new WindupException("Failed to build xml parser due to: " + e.getMessage(), (Throwable)e);
        }
        try {
            Document doc = dBuilder.parse(uri.toString());
            return this.processElement(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new WindupException("Failed to parse document at: " + uri + ", due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<AbstractRuleProvider> getRuleProviders() {
        return this.ruleProviders;
    }

    public void addRuleProvider(AbstractRuleProvider provider) {
        this.ruleProviders.add(provider);
    }

    public RuleProviderBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(RuleProviderBuilder builder) {
        this.builder = builder;
    }

    public ConfigurationRuleParameterWhere getWhere() {
        return this.where;
    }

    public void setWhere(ConfigurationRuleParameterWhere where) {
        this.where = where;
    }

    public void setRule(ConfigurationRuleBuilder rule) {
        this.rule = rule;
    }

    public ConfigurationRuleBuilder getRule() {
        return this.rule;
    }

    public void setAddonContainingInputXML(Addon addonContainingInputXML) {
        this.addonContainingInputXML = addonContainingInputXML;
    }

    public Addon getAddonContainingInputXML() {
        return this.addonContainingInputXML;
    }

    public void setXmlInputPath(Path xmlInputPath) {
        this.xmlInputPath = xmlInputPath;
    }

    public Path getXmlInputPath() {
        return this.xmlInputPath;
    }

    public void setXmlInputRootPath(Path xmlRootInputPath) {
        this.xmlInputRootPath = xmlRootInputPath;
    }

    public Path getXmlInputRootPath() {
        return this.xmlInputRootPath;
    }
}

