/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker.filepath;

import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.ReportResourceFileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.reporting.freemarker.filepath.AbstractGetPrettyPathForFile;

public class GetPrettyPathForFile
extends AbstractGetPrettyPathForFile {
    private static final String NAME = "getPrettyPathForFile";

    @Override
    public String getPath(JavaClassFileModel jcfm) {
        return jcfm.getJavaClass().getQualifiedName();
    }

    @Override
    public String getPath(ReportResourceFileModel model) {
        return "resources/" + model.getPrettyPath();
    }

    @Override
    public String getPath(FileModel model) {
        return model.getPrettyPathWithinProject();
    }

    @Override
    public String getPath(JavaSourceFileModel javaSourceModel) {
        String filename = javaSourceModel.getFileName();
        String packageName = javaSourceModel.getPackageName();
        if (filename.endsWith(".java")) {
            filename = filename.substring(0, filename.length() - 5);
        }
        return packageName == null || packageName.equals("") ? filename : packageName + "." + filename;
    }

    @Override
    public String getMethodName() {
        return NAME;
    }
}

