/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation;

import java.io.File;
import java.io.FileFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.util.Logging;

public class IdentifiedArchiveFileFilter
implements FileFilter {
    private static final Logger LOG = Logging.get(IdentifiedArchiveFileFilter.class);
    private final String archiveName;

    public IdentifiedArchiveFileFilter(ArchiveModel archive) {
        this.archiveName = archive.getArchiveName();
    }

    @Override
    public boolean accept(File file) {
        if (file.isFile()) {
            if (StringUtils.equals((String)file.getName(), (String)"MANIFEST.MF") || StringUtils.equals((String)file.getName(), (String)"pom.xml") || StringUtils.equals((String)file.getName(), (String)"pom.properties") || StringUtils.containsIgnoreCase((String)file.getName(), (String)"license") || StringUtils.containsIgnoreCase((String)file.getName(), (String)"notice") || StringUtils.containsIgnoreCase((String)file.getName(), (String)"lgpl") || StringUtils.containsIgnoreCase((String)file.getName(), (String)"gpl")) {
                LOG.info(this.archiveName + " - Accepting File on Identified Archive: " + file.getName() + ".");
                return true;
            }
            if (LOG.getLevel() == Level.FINE) {
                LOG.fine(this.archiveName + " - Rejecting File on Identified Archive: " + file.getName() + ".");
            }
            return false;
        }
        return true;
    }
}

